/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.robot;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import sun.awt.robot.RobotPeer;
import sun.awt.robot.ScreenCapture;
import sun.awt.robot.ScreenCaptureProducer;

public final class Robot {
    private static final int MAX_DELAY = 60000;
    private RobotPeer peer;
    private Toolkit toolkit;
    private boolean isWaitForIdle = false;
    private int autoDelay = 0;

    public Robot(RobotPeer robotPeer, Toolkit toolkit) {
        this.peer = robotPeer;
        this.toolkit = toolkit;
    }

    public RobotPeer getPeer() {
        return this.peer;
    }

    public void mouseMove(int n, int n2) {
        this.peer.mouseMove(n, n2);
        this.afterEvent();
    }

    public void mousePress(long l) {
        this.peer.mousePress(l);
        this.afterEvent();
    }

    public void mouseRelease(long l) {
        this.peer.mouseRelease(l);
        this.afterEvent();
    }

    public void keyPress(int n) {
        this.peer.keyPress(n);
        this.afterEvent();
    }

    public void keyRelease(int n) {
        this.peer.keyRelease(n);
        this.afterEvent();
    }

    public Color getPixelColor(int n, int n2) {
        Color color = new Color(this.peer.getRGBPixel(n, n2));
        return color;
    }

    public ScreenCapture createScreenCapture(Rectangle rectangle) {
        int[] nArray = this.peer.getRGBPixels(rectangle);
        ScreenCaptureProducer screenCaptureProducer = new ScreenCaptureProducer(nArray, rectangle);
        Image image = this.toolkit.createImage(screenCaptureProducer);
        return new ScreenCapture(this.toolkit.createImage(screenCaptureProducer));
    }

    private void afterEvent() {
        this.autoWaitForIdle();
        this.autoDelay();
    }

    public boolean isWaitForIdle() {
        return this.isWaitForIdle;
    }

    public void setWaitForIdle(boolean bl) {
        this.isWaitForIdle = bl;
    }

    private void autoWaitForIdle() {
        if (this.isWaitForIdle) {
            this.waitForIdle();
        }
    }

    public int getAutoDelay() {
        return this.autoDelay;
    }

    public void setAutoDelay(int n) {
        this.autoDelay = n;
    }

    private void autoDelay() {
        this.delay(this.autoDelay);
    }

    public void delay(int n) {
        if (n < 0 || n > 60000) {
            throw new IllegalArgumentException("Delay must be to 0 to 60,000ms");
        }
        if (n > 0) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void waitForIdle() {
        try {
            EventQueue.invokeAndWait(new QueueSyncer());
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Non-fatal exception:");
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("Non-fatal exception:");
            invocationTargetException.printStackTrace();
        }
    }

    class QueueSyncer
    implements Runnable {
        QueueSyncer() {
        }

        public void run() {
        }
    }
}

