/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuItemPeer;
import sun.awt.motif.MMenuPeer;
import sun.awt.motif.MToolkit;

class MMenuItemPeer
implements MenuItemPeer {
    long pData;
    long jniGlobalRef;
    boolean isCheckbox = false;
    MenuItem target;
    boolean nativeCreated = false;
    private boolean disposed = false;

    private static native void initIDs();

    native void createMenuItem(MMenuPeer var1);

    void create(MMenuPeer mMenuPeer) {
        if (mMenuPeer.nativeCreated) {
            this.createMenuItem(mMenuPeer);
            this.nativeCreated = true;
            this.setEnabled(this.target.isEnabled());
        }
    }

    protected MMenuItemPeer() {
    }

    MMenuItemPeer(MenuItem menuItem) {
        this.target = menuItem;
        MMenuPeer mMenuPeer = (MMenuPeer)MToolkit.targetToPeer(MMenuItemPeer.getParent_NoClientCode(menuItem));
        this.create(mMenuPeer);
    }

    static native MenuContainer getParent_NoClientCode(MenuComponent var0);

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void setLabel(String string) {
        if (!this.nativeCreated) {
            return;
        }
        this.pSetLabel(string);
        MenuShortcut menuShortcut = this.target.getShortcut();
        this.setShortcut(menuShortcut != null ? menuShortcut.toString() : null);
    }

    public void setShortcut(String string) {
        if (!this.nativeCreated) {
            return;
        }
        this.pSetShortcut(string);
    }

    native void pSetLabel(String var1);

    native void pSetShortcut(String var1);

    public void enable() {
        if (!this.nativeCreated) {
            return;
        }
        this.pEnable();
    }

    native void pEnable();

    public void disable() {
        if (!this.nativeCreated) {
            return;
        }
        this.pDisable();
    }

    native void pDisable();

    private void destroyNativeWidgetImpl() {
        if (this.nativeCreated) {
            this.pDispose();
            this.nativeCreated = false;
        }
    }

    void destroyNativeWidget() {
        this.destroyNativeWidgetImpl();
    }

    protected void disposeImpl() {
        this.destroyNativeWidgetImpl();
        MToolkit.targetDisposedPeer(this.target, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            MMenuItemPeer mMenuItemPeer = this;
            synchronized (mMenuItemPeer) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    native void pDispose();

    void postEvent(AWTEvent aWTEvent) {
        MToolkit.postEvent(MToolkit.targetToAppContext(this.target), aWTEvent);
    }

    public void action(final long l, final int n) {
        MToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            public void run() {
                MMenuItemPeer.this.postEvent(new ActionEvent(MMenuItemPeer.this.target, 1001, MMenuItemPeer.this.target.getActionCommand(), l, n));
            }
        });
    }

    static {
        MMenuItemPeer.initIDs();
    }
}

