/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.BytePackedRaster;

public class OffScreenImageSource
implements ImageProducer {
    BufferedImage image;
    int width;
    int height;
    private ImageConsumer theConsumer;

    public OffScreenImageSource(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        this.theConsumer = imageConsumer;
        this.produce();
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return imageConsumer == this.theConsumer;
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        if (this.theConsumer == imageConsumer) {
            this.theConsumer = null;
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private void sendPixels() {
        int n;
        Object object;
        ColorModel colorModel = this.image.getColorModel();
        WritableRaster writableRaster = this.image.getRaster();
        int n2 = writableRaster.getNumDataElements();
        int n3 = writableRaster.getDataBuffer().getDataType();
        int[] nArray = new int[this.width * n2];
        boolean bl = true;
        if (colorModel instanceof IndexColorModel) {
            object = new byte[this.width];
            this.theConsumer.setColorModel(colorModel);
            if (writableRaster instanceof ByteComponentRaster) {
                bl = false;
                for (int i = 0; i < this.height; ++i) {
                    writableRaster.getDataElements(0, i, this.width, 1, object);
                    this.theConsumer.setPixels(0, i, this.width, 1, colorModel, (byte[])object, 0, this.width);
                }
            } else if (writableRaster instanceof BytePackedRaster) {
                bl = false;
                for (int i = 0; i < this.height; ++i) {
                    writableRaster.getPixels(0, i, this.width, 1, nArray);
                    for (n = 0; n < this.width; ++n) {
                        object[n] = (byte)nArray[n];
                    }
                    this.theConsumer.setPixels(0, i, this.width, 1, colorModel, (byte[])object, 0, this.width);
                }
            } else if (n3 == 2 || n3 == 3) {
                bl = false;
                for (int i = 0; i < this.height; ++i) {
                    writableRaster.getPixels(0, i, this.width, 1, nArray);
                    this.theConsumer.setPixels(0, i, this.width, 1, colorModel, nArray, 0, this.width);
                }
            }
        } else if (colorModel instanceof DirectColorModel) {
            this.theConsumer.setColorModel(colorModel);
            bl = false;
            switch (n3) {
                case 3: {
                    for (int i = 0; i < this.height; ++i) {
                        writableRaster.getDataElements(0, i, this.width, 1, nArray);
                        this.theConsumer.setPixels(0, i, this.width, 1, colorModel, nArray, 0, this.width);
                    }
                    break;
                }
                case 0: {
                    byte[] byArray = new byte[this.width];
                    for (int i = 0; i < this.height; ++i) {
                        writableRaster.getDataElements(0, i, this.width, 1, byArray);
                        for (n = 0; n < this.width; ++n) {
                            nArray[n] = byArray[n] & 0xFF;
                        }
                        this.theConsumer.setPixels(0, i, this.width, 1, colorModel, nArray, 0, this.width);
                    }
                    break;
                }
                case 1: {
                    short[] sArray = new short[this.width];
                    for (n = 0; n < this.height; ++n) {
                        writableRaster.getDataElements(0, n, this.width, 1, sArray);
                        for (int i = 0; i < this.width; ++i) {
                            nArray[i] = sArray[i] & 0xFFFF;
                        }
                        this.theConsumer.setPixels(0, n, this.width, 1, colorModel, nArray, 0, this.width);
                    }
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (bl) {
            object = ColorModel.getRGBdefault();
            this.theConsumer.setColorModel((ColorModel)object);
            for (int i = 0; i < this.height; ++i) {
                for (n = 0; n < this.width; ++n) {
                    nArray[n] = this.image.getRGB(n, i);
                }
                this.theConsumer.setPixels(0, i, this.width, 1, (ColorModel)object, nArray, 0, this.width);
            }
        }
    }

    private void produce() {
        if (this.theConsumer != null) {
            this.theConsumer.setDimensions(this.image.getWidth(), this.image.getHeight());
        }
        if (this.theConsumer != null) {
            this.theConsumer.setProperties(new Hashtable());
        }
        this.sendPixels();
        if (this.theConsumer != null) {
            this.theConsumer.imageComplete(2);
        }
    }
}

