/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TransferableProxy
implements Transferable {
    protected final Transferable transferable;
    protected final boolean isLocal;

    public TransferableProxy(Transferable transferable, boolean bl) {
        this.transferable = transferable;
        this.isLocal = bl;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.transferable.getTransferDataFlavors();
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.transferable.isDataFlavorSupported(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        Object object = this.transferable.getTransferData(dataFlavor);
        if (object != null && this.isLocal && dataFlavor.isFlavorSerializedObjectType()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new ObjectOutputStream(byteArrayOutputStream).writeObject(object);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            try {
                object = new ObjectInputStream(byteArrayInputStream).readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.getMessage());
            }
        }
        return object;
    }
}

