/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public abstract class AbstractLayoutCache
implements RowMapper {
    protected NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected boolean rootVisible;
    protected int rowHeight;

    public void setNodeDimensions(NodeDimensions nodeDimensions) {
        this.nodeDimensions = nodeDimensions;
    }

    public NodeDimensions getNodeDimensions() {
        return this.nodeDimensions;
    }

    public void setModel(TreeModel treeModel) {
        this.treeModel = treeModel;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setRootVisible(boolean bl) {
        this.rootVisible = bl;
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRowHeight(int n) {
        this.rowHeight = n;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.setRowMapper(null);
        }
        this.treeSelectionModel = treeSelectionModel;
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.setRowMapper(this);
        }
    }

    public TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public int getPreferredHeight() {
        Rectangle rectangle;
        int n = this.getRowCount();
        if (n > 0 && (rectangle = this.getBounds(this.getPathForRow(n - 1), null)) != null) {
            return rectangle.y + rectangle.height;
        }
        return 0;
    }

    public int getPreferredWidth(Rectangle rectangle) {
        int n = this.getRowCount();
        if (n > 0) {
            int n2;
            TreePath treePath;
            if (rectangle == null) {
                treePath = this.getPathForRow(0);
                n2 = Integer.MAX_VALUE;
            } else {
                treePath = this.getPathClosestTo(rectangle.x, rectangle.y);
                n2 = rectangle.height + rectangle.y;
            }
            Enumeration enumeration = this.getVisiblePathsFrom(treePath);
            if (enumeration != null && enumeration.hasMoreElements()) {
                int n3;
                Rectangle rectangle2 = this.getBounds((TreePath)enumeration.nextElement(), null);
                if (rectangle2 != null) {
                    n3 = rectangle2.x + rectangle2.width;
                    if (rectangle2.y >= n2) {
                        return n3;
                    }
                } else {
                    n3 = 0;
                }
                while (rectangle2 != null && enumeration.hasMoreElements()) {
                    rectangle2 = this.getBounds((TreePath)enumeration.nextElement(), rectangle2);
                    if (rectangle2 != null && rectangle2.y < n2) {
                        n3 = Math.max(n3, rectangle2.x + rectangle2.width);
                        continue;
                    }
                    rectangle2 = null;
                }
                return n3;
            }
        }
        return 0;
    }

    public abstract boolean isExpanded(TreePath var1);

    public abstract Rectangle getBounds(TreePath var1, Rectangle var2);

    public abstract TreePath getPathForRow(int var1);

    public abstract int getRowForPath(TreePath var1);

    public abstract TreePath getPathClosestTo(int var1, int var2);

    public abstract Enumeration getVisiblePathsFrom(TreePath var1);

    public abstract int getVisibleChildCount(TreePath var1);

    public abstract void setExpandedState(TreePath var1, boolean var2);

    public abstract boolean getExpandedState(TreePath var1);

    public abstract int getRowCount();

    public abstract void invalidateSizes();

    public abstract void invalidatePathBounds(TreePath var1);

    public abstract void treeNodesChanged(TreeModelEvent var1);

    public abstract void treeNodesInserted(TreeModelEvent var1);

    public abstract void treeNodesRemoved(TreeModelEvent var1);

    public abstract void treeStructureChanged(TreeModelEvent var1);

    public int[] getRowsForPaths(TreePath[] treePathArray) {
        if (treePathArray == null) {
            return null;
        }
        int n = treePathArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getRowForPath(treePathArray[i]);
        }
        return nArray;
    }

    protected Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
        NodeDimensions nodeDimensions = this.getNodeDimensions();
        if (nodeDimensions != null) {
            return nodeDimensions.getNodeDimensions(object, n, n2, bl, rectangle);
        }
        return null;
    }

    protected boolean isFixedRowHeight() {
        return this.rowHeight > 0;
    }

    public static abstract class NodeDimensions {
        public abstract Rectangle getNodeDimensions(Object var1, int var2, int var3, boolean var4, Rectangle var5);
    }
}

