/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Font;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalFontDesktopProperty;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class DefaultMetalTheme
extends MetalTheme {
    private static final String[] fontNames = new String[]{"Dialog", "Dialog", "Dialog", "Dialog", "Dialog", "Dialog"};
    private static final int[] fontStyles = new int[]{1, 0, 0, 1, 1, 0};
    private static final int[] fontSizes = new int[]{12, 12, 12, 12, 12, 10};
    private static final String[] defaultNames = new String[]{"swing.plaf.metal.controlFont", "swing.plaf.metal.systemFont", "swing.plaf.metal.userFont", "swing.plaf.metal.controlFont", "swing.plaf.metal.controlFont", "swing.plaf.metal.smallFont"};
    private static final ColorUIResource primary1 = new ColorUIResource(102, 102, 153);
    private static final ColorUIResource primary2 = new ColorUIResource(153, 153, 204);
    private static final ColorUIResource primary3 = new ColorUIResource(204, 204, 255);
    private static final ColorUIResource secondary1 = new ColorUIResource(102, 102, 102);
    private static final ColorUIResource secondary2 = new ColorUIResource(153, 153, 153);
    private static final ColorUIResource secondary3 = new ColorUIResource(204, 204, 204);
    private FontDelegate fontDelegate;

    static String getDefaultFontName(int n) {
        return fontNames[n];
    }

    static int getDefaultFontSize(int n) {
        return fontSizes[n];
    }

    static int getDefaultFontStyle(int n) {
        return fontStyles[n];
    }

    static String getDefaultPropertyName(int n) {
        return defaultNames[n];
    }

    public String getName() {
        return "Steel";
    }

    public DefaultMetalTheme() {
        this.install();
    }

    protected ColorUIResource getPrimary1() {
        return primary1;
    }

    protected ColorUIResource getPrimary2() {
        return primary2;
    }

    protected ColorUIResource getPrimary3() {
        return primary3;
    }

    protected ColorUIResource getSecondary1() {
        return secondary1;
    }

    protected ColorUIResource getSecondary2() {
        return secondary2;
    }

    protected ColorUIResource getSecondary3() {
        return secondary3;
    }

    public FontUIResource getControlTextFont() {
        return this.getFont(0);
    }

    public FontUIResource getSystemTextFont() {
        return this.getFont(1);
    }

    public FontUIResource getUserTextFont() {
        return this.getFont(2);
    }

    public FontUIResource getMenuTextFont() {
        return this.getFont(3);
    }

    public FontUIResource getWindowTitleFont() {
        return this.getFont(4);
    }

    public FontUIResource getSubTextFont() {
        return this.getFont(5);
    }

    private FontUIResource getFont(int n) {
        return this.fontDelegate.getFont(n);
    }

    void install() {
        this.fontDelegate = MetalLookAndFeel.isWindows() && MetalLookAndFeel.useSystemFonts() ? new WindowsFontDelegate() : new FontDelegate();
    }

    boolean isSystemTheme() {
        return this.getClass() == DefaultMetalTheme.class;
    }

    private static class WindowsFontDelegate
    extends FontDelegate {
        private MetalFontDesktopProperty[] props = new MetalFontDesktopProperty[6];
        private boolean[] checkedPriviledged = new boolean[6];

        public FontUIResource getFont(int n) {
            if (this.fonts[n] != null) {
                return this.fonts[n];
            }
            if (!this.checkedPriviledged[n]) {
                Font font = this.getPrivilegedFont(n);
                this.checkedPriviledged[n] = true;
                if (font != null) {
                    this.fonts[n] = new FontUIResource(font);
                    return this.fonts[n];
                }
            }
            if (this.props[n] == null) {
                this.props[n] = new MetalFontDesktopProperty(n);
            }
            return (FontUIResource)this.props[n].createValue(null);
        }
    }

    private static class FontDelegate {
        private static int[] defaultMapping = new int[]{0, 1, 2, 0, 0, 5};
        FontUIResource[] fonts = new FontUIResource[6];

        public FontUIResource getFont(int n) {
            if (this.fonts[n = defaultMapping[n]] == null) {
                Font font = this.getPrivilegedFont(n);
                if (font == null) {
                    font = new Font(DefaultMetalTheme.getDefaultFontName(n), DefaultMetalTheme.getDefaultFontStyle(n), DefaultMetalTheme.getDefaultFontSize(n));
                }
                this.fonts[n] = new FontUIResource(font);
            }
            return this.fonts[n];
        }

        protected Font getPrivilegedFont(int n) {
            return (Font)AccessController.doPrivileged(new PrivilegedAction(this, n){
                private final /* synthetic */ int val$key;
                private final /* synthetic */ FontDelegate this$0;
                {
                    this.this$0 = fontDelegate;
                    this.val$key = n;
                }

                public Object run() {
                    return Font.getFont(DefaultMetalTheme.getDefaultPropertyName(this.val$key));
                }
            });
        }
    }
}

