/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneConstants;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants {
    protected JScrollPane scrollpane;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;
    private MouseWheelListener mouseScrollListener;
    private PropertyChangeListener vsbPropertyChangeListener;
    private PropertyChangeListener hsbPropertyChangeListener;
    private PropertyChangeListener sbPropertyChangeListener;
    private boolean setValueCalled = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollPaneUI();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Border border = this.scrollpane.getViewportBorder();
        if (border != null) {
            Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
            border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void installDefaults(JScrollPane jScrollPane) {
        LookAndFeel.installBorder(jScrollPane, "ScrollPane.border");
        LookAndFeel.installColorsAndFont(jScrollPane, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        Border border = jScrollPane.getViewportBorder();
        if (border == null || border instanceof UIResource) {
            border = UIManager.getBorder("ScrollPane.viewportBorder");
            jScrollPane.setViewportBorder(border);
        }
    }

    protected void installListeners(JScrollPane jScrollPane) {
        this.vsbChangeListener = this.createVSBChangeListener();
        this.vsbPropertyChangeListener = this.createVSBPropertyChangeListener();
        this.hsbChangeListener = this.createHSBChangeListener();
        this.hsbPropertyChangeListener = this.createHSBPropertyChangeListener();
        this.viewportChangeListener = this.createViewportChangeListener();
        this.spPropertyChangeListener = this.createPropertyChangeListener();
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        if (jViewport != null) {
            jViewport.addChangeListener(this.viewportChangeListener);
        }
        if (jScrollBar != null) {
            jScrollBar.getModel().addChangeListener(this.vsbChangeListener);
            jScrollBar.addPropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.getModel().addChangeListener(this.hsbChangeListener);
            jScrollBar2.addPropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.addPropertyChangeListener(this.spPropertyChangeListener);
        this.mouseScrollListener = this.createMouseWheelListener();
        this.scrollpane.addMouseWheelListener(this.mouseScrollListener);
    }

    protected void installKeyboardActions(JScrollPane jScrollPane) {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jScrollPane, actionMap);
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)UIManager.get("ScrollPane.ancestorInputMap");
            if (this.scrollpane.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)UIManager.get("ScrollPane.ancestorInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("ScrollPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("ScrollPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("scrollUp", new ScrollAction("scrollUp", 1, -1, true));
        actionMapUIResource.put("scrollDown", new ScrollAction("scrollDown", 1, 1, true));
        actionMapUIResource.put("scrollHome", new ScrollHomeAction("ScrollHome"));
        actionMapUIResource.put("scrollEnd", new ScrollEndAction("ScrollEnd"));
        actionMapUIResource.put("unitScrollUp", new ScrollAction("UnitScrollUp", 1, -1, false));
        actionMapUIResource.put("unitScrollDown", new ScrollAction("UnitScrollDown", 1, 1, false));
        if (this.scrollpane.getComponentOrientation().isLeftToRight()) {
            actionMapUIResource.put("scrollLeft", new ScrollAction("scrollLeft", 0, -1, true));
            actionMapUIResource.put("scrollRight", new ScrollAction("ScrollRight", 0, 1, true));
            actionMapUIResource.put("unitScrollRight", new ScrollAction("UnitScrollRight", 0, 1, false));
            actionMapUIResource.put("unitScrollLeft", new ScrollAction("UnitScrollLeft", 0, -1, false));
        } else {
            actionMapUIResource.put("scrollLeft", new ScrollAction("scrollLeft", 0, 1, true));
            actionMapUIResource.put("scrollRight", new ScrollAction("ScrollRight", 0, -1, true));
            actionMapUIResource.put("unitScrollRight", new ScrollAction("UnitScrollRight", 0, -1, false));
            actionMapUIResource.put("unitScrollLeft", new ScrollAction("UnitScrollLeft", 0, 1, false));
        }
        return actionMapUIResource;
    }

    public void installUI(JComponent jComponent) {
        this.scrollpane = (JScrollPane)jComponent;
        this.installDefaults(this.scrollpane);
        this.installListeners(this.scrollpane);
        this.installKeyboardActions(this.scrollpane);
    }

    protected void uninstallDefaults(JScrollPane jScrollPane) {
        LookAndFeel.uninstallBorder(this.scrollpane);
        if (this.scrollpane.getViewportBorder() instanceof UIResource) {
            this.scrollpane.setViewportBorder(null);
        }
    }

    protected void uninstallListeners(JComponent jComponent) {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        if (jViewport != null) {
            jViewport.removeChangeListener(this.viewportChangeListener);
        }
        if (jScrollBar != null) {
            jScrollBar.getModel().removeChangeListener(this.vsbChangeListener);
            jScrollBar.removePropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.getModel().removeChangeListener(this.hsbChangeListener);
            jScrollBar2.removePropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.removePropertyChangeListener(this.spPropertyChangeListener);
        if (this.mouseScrollListener != null) {
            this.scrollpane.removeMouseWheelListener(this.mouseScrollListener);
        }
        this.vsbChangeListener = null;
        this.hsbChangeListener = null;
        this.viewportChangeListener = null;
        this.spPropertyChangeListener = null;
        this.mouseScrollListener = null;
    }

    protected void uninstallKeyboardActions(JScrollPane jScrollPane) {
        SwingUtilities.replaceUIActionMap(jScrollPane, null);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, null);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(this.scrollpane);
        this.uninstallListeners(this.scrollpane);
        this.uninstallKeyboardActions(this.scrollpane);
        this.scrollpane = null;
    }

    protected void syncScrollPaneWithViewport() {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        JViewport jViewport2 = this.scrollpane.getRowHeader();
        JViewport jViewport3 = this.scrollpane.getColumnHeader();
        boolean bl = this.scrollpane.getComponentOrientation().isLeftToRight();
        if (jViewport != null) {
            int n;
            int n2;
            int n3;
            Dimension dimension = jViewport.getExtentSize();
            Dimension dimension2 = jViewport.getViewSize();
            Point point = jViewport.getViewPosition();
            if (jScrollBar != null) {
                n3 = dimension.height;
                n2 = dimension2.height;
                n = Math.max(0, Math.min(point.y, n2 - n3));
                jScrollBar.setValues(n, n3, 0, n2);
            }
            if (jScrollBar2 != null) {
                n3 = dimension.width;
                n2 = dimension2.width;
                if (bl) {
                    n = Math.max(0, Math.min(point.x, n2 - n3));
                } else {
                    int n4 = jScrollBar2.getValue();
                    if (this.setValueCalled && n2 - n4 == point.x) {
                        n = Math.max(0, Math.min(n2 - n3, n4));
                        if (n3 != 0) {
                            this.setValueCalled = false;
                        }
                    } else if (n3 > n2) {
                        point.x = n2 - n3;
                        jViewport.setViewPosition(point);
                        n = 0;
                    } else {
                        n = Math.max(0, Math.min(n2 - n3, n2 - n3 - point.x));
                    }
                }
                jScrollBar2.setValues(n, n3, 0, n2);
            }
            if (jViewport2 != null) {
                Point point2 = jViewport2.getViewPosition();
                point2.y = jViewport.getViewPosition().y;
                point2.x = 0;
                jViewport2.setViewPosition(point2);
            }
            if (jViewport3 != null) {
                Point point3 = jViewport3.getViewPosition();
                point3.x = bl ? jViewport.getViewPosition().x : Math.max(0, jViewport.getViewPosition().x);
                point3.y = 0;
                jViewport3.setViewPosition(point3);
            }
        }
    }

    protected ChangeListener createViewportChangeListener() {
        return new ViewportChangeHandler();
    }

    private PropertyChangeListener createHSBPropertyChangeListener() {
        return this.getSBPropertyChangeListener();
    }

    private PropertyChangeListener getSBPropertyChangeListener() {
        if (this.sbPropertyChangeListener == null) {
            this.sbPropertyChangeListener = new ScrollBarPropertyChangeHandler();
        }
        return this.sbPropertyChangeListener;
    }

    protected ChangeListener createHSBChangeListener() {
        return new HSBChangeListener();
    }

    private PropertyChangeListener createVSBPropertyChangeListener() {
        return this.getSBPropertyChangeListener();
    }

    protected ChangeListener createVSBChangeListener() {
        return new VSBChangeListener();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent propertyChangeEvent) {
        this.scrollpane.revalidate();
        this.scrollpane.repaint();
    }

    protected void updateViewport(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getOldValue();
        JViewport jViewport2 = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            jViewport.removeChangeListener(this.viewportChangeListener);
        }
        if (jViewport2 != null) {
            int n;
            int n2;
            Point point = jViewport2.getViewPosition();
            point.x = this.scrollpane.getComponentOrientation().isLeftToRight() ? Math.max(point.x, 0) : ((n2 = jViewport2.getExtentSize().width) > (n = jViewport2.getViewSize().width) ? n - n2 : Math.max(0, Math.min(n - n2, point.x)));
            point.y = Math.max(point.y, 0);
            jViewport2.setViewPosition(point);
            jViewport2.addChangeListener(this.viewportChangeListener);
        }
    }

    protected void updateRowHeader(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            JViewport jViewport2 = this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.y = jViewport2 != null ? jViewport2.getViewPosition().y : 0;
            jViewport.setViewPosition(point);
        }
    }

    protected void updateColumnHeader(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            JViewport jViewport2 = this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.x = jViewport2 == null ? 0 : (this.scrollpane.getComponentOrientation().isLeftToRight() ? jViewport2.getViewPosition().x : Math.max(0, jViewport2.getViewPosition().x));
            jViewport.setViewPosition(point);
            this.scrollpane.add((Component)jViewport, "COLUMN_HEADER");
        }
    }

    private void updateHorizontalScrollBar(PropertyChangeEvent propertyChangeEvent) {
        this.updateScrollBar(propertyChangeEvent, this.hsbChangeListener, this.hsbPropertyChangeListener);
    }

    private void updateVerticalScrollBar(PropertyChangeEvent propertyChangeEvent) {
        this.updateScrollBar(propertyChangeEvent, this.vsbChangeListener, this.vsbPropertyChangeListener);
    }

    private void updateScrollBar(PropertyChangeEvent propertyChangeEvent, ChangeListener changeListener, PropertyChangeListener propertyChangeListener) {
        JScrollBar jScrollBar = (JScrollBar)propertyChangeEvent.getOldValue();
        if (jScrollBar != null) {
            if (changeListener != null) {
                jScrollBar.getModel().removeChangeListener(changeListener);
            }
            if (propertyChangeListener != null) {
                jScrollBar.removePropertyChangeListener(propertyChangeListener);
            }
        }
        if ((jScrollBar = (JScrollBar)propertyChangeEvent.getNewValue()) != null) {
            if (changeListener != null) {
                jScrollBar.getModel().addChangeListener(changeListener);
            }
            if (propertyChangeListener != null) {
                jScrollBar.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    private static class ScrollEndAction
    extends AbstractAction {
        protected ScrollEndAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Rectangle rectangle2 = component.getBounds();
                if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    jViewport.setViewPosition(new Point(rectangle2.width - rectangle.width, rectangle2.height - rectangle.height));
                } else {
                    jViewport.setViewPosition(new Point(0, rectangle2.height - rectangle.height));
                }
            }
        }
    }

    private static class ScrollHomeAction
    extends AbstractAction {
        protected ScrollHomeAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    jViewport.setViewPosition(new Point(0, 0));
                } else {
                    Rectangle rectangle = jViewport.getViewRect();
                    Rectangle rectangle2 = component.getBounds();
                    jViewport.setViewPosition(new Point(rectangle2.width - rectangle.width, 0));
                }
            }
        }
    }

    private static class ScrollAction
    extends AbstractAction {
        protected int orientation;
        protected int direction;
        private boolean block;

        protected ScrollAction(String string, int n, int n2, boolean bl) {
            super(string);
            this.orientation = n;
            this.direction = n2;
            this.block = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Dimension dimension = component.getSize();
                int n = component instanceof Scrollable ? (this.block ? ((Scrollable)((Object)component)).getScrollableBlockIncrement(rectangle, this.orientation, this.direction) : ((Scrollable)((Object)component)).getScrollableUnitIncrement(rectangle, this.orientation, this.direction)) : (this.block ? (this.orientation == 1 ? rectangle.height : rectangle.width) : 10);
                if (this.orientation == 1) {
                    rectangle.y += n * this.direction;
                    if (rectangle.y + rectangle.height > dimension.height) {
                        rectangle.y = Math.max(0, dimension.height - rectangle.height);
                    } else if (rectangle.y < 0) {
                        rectangle.y = 0;
                    }
                } else if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    rectangle.x += n * this.direction;
                    if (rectangle.x + rectangle.width > dimension.width) {
                        rectangle.x = Math.max(0, dimension.width - rectangle.width);
                    } else if (rectangle.x < 0) {
                        rectangle.x = 0;
                    }
                } else {
                    rectangle.x -= n * this.direction;
                    rectangle.x = rectangle.width > dimension.width ? dimension.width - rectangle.width : Math.max(0, Math.min(dimension.width - rectangle.width, rectangle.x));
                }
                jViewport.setViewPosition(rectangle.getLocation());
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("verticalScrollBarDisplayPolicy")) {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string.equals("horizontalScrollBarDisplayPolicy")) {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string.equals("viewport")) {
                BasicScrollPaneUI.this.updateViewport(propertyChangeEvent);
            } else if (string.equals("rowHeader")) {
                BasicScrollPaneUI.this.updateRowHeader(propertyChangeEvent);
            } else if (string.equals("columnHeader")) {
                BasicScrollPaneUI.this.updateColumnHeader(propertyChangeEvent);
            } else if (string.equals("verticalScrollBar")) {
                BasicScrollPaneUI.this.updateVerticalScrollBar(propertyChangeEvent);
            } else if (string.equals("horizontalScrollBar")) {
                BasicScrollPaneUI.this.updateHorizontalScrollBar(propertyChangeEvent);
            } else if (string.equals("componentOrientation")) {
                BasicScrollPaneUI.this.scrollpane.revalidate();
                BasicScrollPaneUI.this.scrollpane.repaint();
                InputMap inputMap = BasicScrollPaneUI.this.getInputMap(1);
                SwingUtilities.replaceUIInputMap(BasicScrollPaneUI.this.scrollpane, 1, inputMap);
                UIManager.getLookAndFeelDefaults().put("ScrollPane.actionMap", (Object)null);
                ActionMap actionMap = BasicScrollPaneUI.this.getActionMap();
                SwingUtilities.replaceUIActionMap(BasicScrollPaneUI.this.scrollpane, actionMap);
            }
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        protected MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (BasicScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && mouseWheelEvent.getScrollAmount() != 0) {
                JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int n = 0;
                if (!(jScrollBar != null && jScrollBar.isVisible() || (jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) != null && jScrollBar.isVisible())) {
                    return;
                }
                int n2 = n = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
                if (mouseWheelEvent.getScrollType() == 0) {
                    BasicScrollBarUI.scrollByUnits(jScrollBar, n, mouseWheelEvent.getScrollAmount());
                } else if (mouseWheelEvent.getScrollType() == 1) {
                    BasicScrollBarUI.scrollByBlock(jScrollBar, n);
                }
            }
        }
    }

    private class ScrollBarPropertyChangeHandler
    implements PropertyChangeListener {
        private ScrollBarPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if ("model".equals(string)) {
                JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)propertyChangeEvent.getOldValue();
                ChangeListener changeListener = null;
                if (object == jScrollBar) {
                    changeListener = BasicScrollPaneUI.this.vsbChangeListener;
                } else if (object == BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                    jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    changeListener = BasicScrollPaneUI.this.hsbChangeListener;
                }
                if (changeListener != null) {
                    if (boundedRangeModel != null) {
                        boundedRangeModel.removeChangeListener(changeListener);
                    }
                    if (jScrollBar.getModel() != null) {
                        jScrollBar.getModel().addChangeListener(changeListener);
                    }
                }
            } else if ("componentOrientation".equals(string) && object == BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
                Point point = jViewport.getViewPosition();
                point.x = BasicScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight() ? jScrollBar.getValue() : jViewport.getViewSize().width - jViewport.getExtentSize().width - jScrollBar.getValue();
                jViewport.setViewPosition(point);
            }
        }
    }

    public class VSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                Point point = jViewport.getViewPosition();
                point.y = boundedRangeModel.getValue();
                jViewport.setViewPosition(point);
            }
        }
    }

    public class HSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                Point point = jViewport.getViewPosition();
                int n = boundedRangeModel.getValue();
                if (BasicScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight()) {
                    point.x = n;
                } else {
                    int n2 = jViewport.getViewSize().width;
                    int n3 = jViewport.getExtentSize().width;
                    int n4 = point.x;
                    point.x = n2 - n3 - n;
                    if (n3 == 0 && n != 0 && n4 == n2) {
                        BasicScrollPaneUI.this.setValueCalled = true;
                    } else if (n3 != 0 && n4 < 0 && point.x == 0) {
                        point.x += n;
                    }
                }
                jViewport.setViewPosition(point);
            }
        }
    }

    public class ViewportChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollPaneUI.this.syncScrollPaneWithViewport();
        }
    }
}

