/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import java.util.Stack;
import javax.swing.GraphicsWrapper;
import javax.swing.SwingUtilities;

class SwingGraphics
extends Graphics
implements GraphicsWrapper {
    Graphics graphics;
    Graphics originalGraphics;
    Rectangle clipRect;
    Color currentColor;
    Font currentFont;
    Color currentXORMode;
    int translateX = 0;
    int translateY = 0;
    SwingGraphics previous;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private static Stack pool = new Stack();

    public Graphics create() {
        return SwingGraphics.createSwingGraphics(this);
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        return SwingGraphics.createSwingGraphics(this, n, n2, n3, n4);
    }

    public Graphics subGraphics() {
        return this.graphics;
    }

    SwingGraphics(Graphics graphics) {
        if (graphics == null) {
            Thread.dumpStack();
        }
        this.init(graphics);
    }

    void init(Graphics graphics) {
        if (graphics instanceof SwingGraphics) {
            SwingGraphics swingGraphics = (SwingGraphics)graphics;
            this.originalGraphics = swingGraphics.originalGraphics;
            this.graphics = swingGraphics.graphics;
            this.previous = swingGraphics;
            if (this.clipRect == null) {
                this.clipRect = new Rectangle(swingGraphics.clipRect.x, swingGraphics.clipRect.y, swingGraphics.clipRect.width, swingGraphics.clipRect.height);
            } else {
                this.clipRect.x = swingGraphics.clipRect.x;
                this.clipRect.y = swingGraphics.clipRect.y;
                this.clipRect.width = swingGraphics.clipRect.width;
                this.clipRect.height = swingGraphics.clipRect.height;
            }
            this.currentColor = swingGraphics.currentColor;
            this.currentFont = swingGraphics.currentFont;
            this.currentXORMode = swingGraphics.currentXORMode;
        } else {
            this.originalGraphics = graphics;
            this.graphics = graphics.create();
            this.previous = null;
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                if (this.clipRect == null) {
                    this.clipRect = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
                } else {
                    this.clipRect.y = 0;
                    this.clipRect.x = 0;
                    this.clipRect.height = Integer.MAX_VALUE;
                    this.clipRect.width = Integer.MAX_VALUE;
                }
            } else {
                this.clipRect = rectangle;
            }
            this.currentColor = graphics.getColor();
            this.currentFont = graphics.getFont();
            this.currentXORMode = null;
        }
    }

    public static Graphics createSwingGraphics(Graphics graphics) {
        if (graphics == null) {
            Thread.dumpStack();
            return null;
        }
        return graphics.create();
    }

    static Graphics createSwingGraphics(Graphics graphics, int n, int n2, int n3, int n4) {
        return graphics.create(n, n2, n3, n4);
    }

    public void translate(int n, int n2) {
        this.graphics.translate(n, n2);
        this.translateX += n;
        this.translateY += n2;
        this.clipRect.x -= n;
        this.clipRect.y -= n2;
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void setColor(Color color) {
        this.graphics.setColor(color);
        this.currentColor = color;
    }

    public void setPaintMode() {
        this.graphics.setPaintMode();
        this.currentXORMode = null;
    }

    public void setXORMode(Color color) {
        this.graphics.setXORMode(color);
        this.currentXORMode = color;
    }

    public Font getFont() {
        return this.currentFont;
    }

    public void setFont(Font font) {
        this.graphics.setFont(font);
        this.currentFont = font;
    }

    public FontMetrics getFontMetrics() {
        return this.graphics.getFontMetrics();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.graphics.getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        return new Rectangle(this.clipRect);
    }

    public boolean isClipIntersecting(Rectangle rectangle) {
        if (this.clipRect.x >= rectangle.x + rectangle.width || this.clipRect.x + this.clipRect.width <= rectangle.x || this.clipRect.y >= rectangle.y + rectangle.height || this.clipRect.y + this.clipRect.height <= rectangle.y) {
            return false;
        }
        return this.clipRect.width != 0 && this.clipRect.height != 0 && rectangle.width != 0 && rectangle.height != 0;
    }

    public int getClipX() {
        return this.clipRect.x;
    }

    public int getClipY() {
        return this.clipRect.y;
    }

    public int getClipWidth() {
        return this.clipRect.width;
    }

    public int getClipHeight() {
        return this.clipRect.height;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.graphics.clipRect(n, n2, n3, n4);
        this._changeClip(n, n2, n3, n4, false);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.graphics.setClip(n, n2, n3, n4);
        this._changeClip(n, n2, n3, n4, true);
    }

    public Shape getClip() {
        return this.graphics.getClip();
    }

    public void setClip(Shape shape) {
        this.graphics.setClip(shape);
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this._changeClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.copyArea(n, n2, n3, n4, n5, n6);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.graphics.drawLine(n, n2, n3, n4);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.graphics.fillRect(n, n2, n3, n4);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.graphics.drawRect(n, n2, n3, n4);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.graphics.clearRect(n, n2, n3, n4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.graphics.draw3DRect(n, n2, n3, n4, bl);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.graphics.fill3DRect(n, n2, n3, n4, bl);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.graphics.drawOval(n, n2, n3, n4);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.graphics.fillOval(n, n2, n3, n4);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.graphics.drawPolyline(nArray, nArray2, n);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.graphics.drawPolygon(nArray, nArray2, n);
    }

    public void drawPolygon(Polygon polygon) {
        this.graphics.drawPolygon(polygon);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.graphics.fillPolygon(nArray, nArray2, n);
    }

    public void fillPolygon(Polygon polygon) {
        this.graphics.fillPolygon(polygon);
    }

    public void drawString(String string, int n, int n2) {
        this.graphics.drawString(string, n, n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.graphics.drawString(attributedCharacterIterator, n, n2);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.graphics.drawChars(cArray, n, n2, n3, n4);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.graphics.drawBytes(byArray, n, n2, n3, n4);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    private void resetGraphics() {
        if (this.currentFont != this.previous.currentFont) {
            this.setFont(this.previous.currentFont);
        }
        if (this.currentColor != this.previous.currentColor) {
            this.setColor(this.previous.currentColor);
        }
        if (this.currentXORMode != this.previous.currentXORMode) {
            if (this.previous.currentXORMode == null) {
                this.setPaintMode();
            } else {
                this.setXORMode(this.previous.currentXORMode);
            }
        }
        if (this.translateX != 0 || this.translateY != 0) {
            this.translate(-this.translateX, -this.translateY);
        }
        if (this.clipRect.x != this.previous.clipRect.x || this.clipRect.y != this.previous.clipRect.y || this.clipRect.width != this.previous.clipRect.width || this.clipRect.height != this.previous.clipRect.height) {
            this.setClip(this.previous.clipRect.x, this.previous.clipRect.y, this.previous.clipRect.width, this.previous.clipRect.height);
        }
    }

    public void dispose() {
        if (this.graphics != null) {
            if (this.previous != null) {
                this.resetGraphics();
            } else {
                this.graphics.dispose();
                this.translateY = 0;
                this.translateX = 0;
            }
        } else {
            this.translateY = 0;
            this.translateX = 0;
        }
        this.graphics = null;
        SwingGraphics.recycleSwingGraphics(this);
    }

    public void finalize() {
        this.graphics.finalize();
    }

    public String toString() {
        String string = this.currentFont.toString();
        string = string.substring(string.indexOf(91));
        return "SwingGraphics(0x" + Integer.toHexString(this.hashCode()) + ") [subGraphics " + this.originalGraphics.getClass().getName() + "\n   translate [x=" + this.translateX + ",y=" + this.translateY + "] clip [x=" + this.clipRect.x + ",y=" + this.clipRect.y + ",w=" + this.clipRect.width + ",h=" + this.clipRect.height + "]\n   color [r=" + this.currentColor.getRed() + ",g=" + this.currentColor.getGreen() + ",b=" + this.currentColor.getBlue() + "] font " + string + "]";
    }

    public Rectangle getClipRect() {
        return this.graphics.getClipRect();
    }

    private void _changeClip(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.clipRect.x = n;
            this.clipRect.y = n2;
            this.clipRect.width = n3;
            this.clipRect.height = n4;
        } else {
            SwingUtilities.computeIntersection(n, n2, n3, n4, this.clipRect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycleSwingGraphics(SwingGraphics swingGraphics) {
        Stack stack = pool;
        synchronized (stack) {
            pool.push(swingGraphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwingGraphics getRecycledSwingGraphics() {
        SwingGraphics swingGraphics = null;
        Stack stack = pool;
        synchronized (stack) {
            if (pool.size() > 0) {
                swingGraphics = (SwingGraphics)pool.pop();
            }
        }
        return swingGraphics;
    }
}

