/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.TargetDataLine;

public class AudioInputStream
extends InputStream {
    private PushbackInputStream stream;
    private boolean markSupported;
    protected AudioFormat format;
    protected long frameLength;
    protected int frameSize;
    protected long framePos;
    private long markpos;

    public AudioInputStream(InputStream inputStream, AudioFormat audioFormat, long l) {
        this.format = audioFormat;
        this.frameLength = l;
        this.frameSize = audioFormat.getFrameSize();
        if (this.frameSize == -1) {
            this.frameSize = 1;
        }
        this.stream = this.frameSize > 1 ? new PushbackInputStream(inputStream, this.frameSize - 1) : new PushbackInputStream(inputStream, 1);
        this.framePos = 0L;
        this.markpos = 0L;
        this.markSupported = inputStream.markSupported();
    }

    public AudioInputStream(TargetDataLine targetDataLine) {
        TargetDataLineInputStream targetDataLineInputStream = new TargetDataLineInputStream(targetDataLine);
        this.format = targetDataLine.getFormat();
        this.frameLength = -1L;
        this.frameSize = this.format.getFrameSize();
        if (this.frameSize == -1) {
            this.frameSize = 1;
        }
        this.stream = this.frameSize > 1 ? new PushbackInputStream(targetDataLineInputStream, this.frameSize - 1) : new PushbackInputStream(targetDataLineInputStream, 1);
        this.framePos = 0L;
        this.markpos = 0L;
        this.markSupported = this.stream.markSupported();
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    public int read() throws IOException {
        if (this.frameSize != 1) {
            throw new IOException("cannot read a single byte if frame size != 1");
        }
        if (this.frameLength != -1L && this.framePos >= this.frameLength) {
            return -1;
        }
        int n = this.stream.read();
        if (n >= 0) {
            ++this.framePos;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (n2 % this.frameSize != 0) {
            n2 -= n2 % this.frameSize;
        }
        if (this.frameLength != -1L) {
            if (this.framePos >= this.frameLength) {
                return -1;
            }
            if ((long)(n2 / this.frameSize) > this.frameLength - this.framePos) {
                n2 = (int)(this.frameLength - this.framePos) * this.frameSize;
            }
        }
        if ((n4 = this.stream.read(byArray, n, n2)) > 0 && (n3 = n4 % this.frameSize) > 0) {
            this.stream.unread(byArray, n + n4 - n3, n3);
            n4 -= n3;
        }
        this.framePos += (long)(n4 / this.frameSize);
        return n4;
    }

    public long skip(long l) throws IOException {
        long l2;
        if (l % (long)this.frameSize != 0L) {
            l -= l % (long)this.frameSize;
        }
        if (this.frameLength != -1L && l / (long)this.frameSize > this.frameLength - this.framePos) {
            l = (this.frameLength - this.framePos) * (long)this.frameSize;
        }
        if ((l2 = this.stream.skip(l)) % (long)this.frameSize != 0L) {
            throw new IOException("Could not skip an integer number of frames.");
        }
        if (l2 >= 0L) {
            this.framePos += l2 / (long)this.frameSize;
        }
        return l2;
    }

    public int available() throws IOException {
        int n = this.stream.available();
        if (this.frameLength != -1L && (long)(n / this.frameSize) > this.frameLength - this.framePos) {
            return (int)(this.frameLength - this.framePos) * this.frameSize;
        }
        return n;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public void mark(int n) {
        this.stream.mark(n);
        if (this.markSupported()) {
            this.markpos = this.framePos;
        }
    }

    public void reset() throws IOException {
        this.stream.reset();
        this.framePos = this.markpos;
    }

    public boolean markSupported() {
        return this.markSupported;
    }

    private class TargetDataLineInputStream
    extends InputStream {
        TargetDataLine line;

        TargetDataLineInputStream(TargetDataLine targetDataLine) {
            this.line = targetDataLine;
        }

        public int available() throws IOException {
            return this.line.available();
        }

        public void close() throws IOException {
            if (this.line.isActive()) {
                this.line.flush();
                this.line.stop();
            }
            this.line.close();
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n == -1) {
                return -1;
            }
            n = byArray[0];
            if (this.line.getFormat().getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
                n += 128;
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                return this.line.read(byArray, n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
        }
    }
}

