/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import javax.sound.midi.spi.SoundbankReader;

public class MidiSystem {
    private static final String defaultServicesClassName = "com.sun.media.sound.DefaultServices";
    private static final String jdk13ServicesClassName = "com.sun.media.sound.JDK13Services";
    private static final String servicesMethodName = "getProviders";
    private static final Class[] servicesParamTypes = new Class[]{String.class};

    private MidiSystem() {
    }

    public static MidiDevice.Info[] getMidiDeviceInfo() {
        return MidiSystem.getGenericDeviceInfo(MidiDevice.class);
    }

    public static MidiDevice getMidiDevice(MidiDevice.Info info) throws MidiUnavailableException {
        return (MidiDevice)MidiSystem.getGenericDevice(null, info);
    }

    public static Receiver getReceiver() throws MidiUnavailableException {
        return ((MidiDevice)MidiSystem.getGenericDevice(Receiver.class, null)).getReceiver();
    }

    public static Transmitter getTransmitter() throws MidiUnavailableException {
        return ((MidiDevice)MidiSystem.getGenericDevice(Transmitter.class, null)).getTransmitter();
    }

    public static Synthesizer getSynthesizer() throws MidiUnavailableException {
        return (Synthesizer)MidiSystem.getGenericDevice(Synthesizer.class, null);
    }

    public static Sequencer getSequencer() throws MidiUnavailableException {
        return (Sequencer)MidiSystem.getGenericDevice(Sequencer.class, null);
    }

    public static Soundbank getSoundbank(InputStream inputStream) throws InvalidMidiDataException, IOException {
        SoundbankReader soundbankReader = null;
        Soundbank soundbank = null;
        Vector vector = MidiSystem.getSoundbankReaders();
        for (int i = vector.size() - 1; i >= 0; --i) {
            soundbankReader = (SoundbankReader)vector.elementAt(i);
            soundbank = soundbankReader.getSoundbank(inputStream);
            if (soundbank == null) continue;
            return soundbank;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    public static Soundbank getSoundbank(URL uRL) throws InvalidMidiDataException, IOException {
        SoundbankReader soundbankReader = null;
        Soundbank soundbank = null;
        Vector vector = MidiSystem.getSoundbankReaders();
        for (int i = vector.size() - 1; i >= 0; --i) {
            soundbankReader = (SoundbankReader)vector.elementAt(i);
            soundbank = soundbankReader.getSoundbank(uRL);
            if (soundbank == null) continue;
            return soundbank;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    public static Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return MidiSystem.getSoundbank(fileInputStream);
    }

    public static MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        MidiFileFormat midiFileFormat = null;
        for (int i = midiFileReaderArray.length - 1; i >= 0; --i) {
            try {
                midiFileFormat = midiFileReaderArray[i].getMidiFileFormat(inputStream);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (midiFileFormat == null) {
            throw new InvalidMidiDataException("input stream is not a supported file type");
        }
        return midiFileFormat;
    }

    public static MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        MidiFileFormat midiFileFormat = null;
        for (int i = midiFileReaderArray.length - 1; i >= 0; --i) {
            try {
                midiFileFormat = midiFileReaderArray[i].getMidiFileFormat(uRL);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (midiFileFormat == null) {
            throw new InvalidMidiDataException("url is not a supported file type");
        }
        return midiFileFormat;
    }

    public static MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        MidiFileFormat midiFileFormat = null;
        for (int i = midiFileReaderArray.length - 1; i >= 0; --i) {
            try {
                midiFileFormat = midiFileReaderArray[i].getMidiFileFormat(file);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (midiFileFormat == null) {
            throw new InvalidMidiDataException("file is not a supported file type");
        }
        return midiFileFormat;
    }

    public static Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        for (int i = midiFileReaderArray.length - 1; i >= 0; --i) {
            try {
                sequence = midiFileReaderArray[i].getSequence(inputStream);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from input stream");
        }
        return sequence;
    }

    public static Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        for (int i = midiFileReaderArray.length - 1; i >= 0; --i) {
            try {
                sequence = midiFileReaderArray[i].getSequence(uRL);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from URL");
        }
        return sequence;
    }

    public static Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        MidiFileReader[] midiFileReaderArray = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        for (int i = midiFileReaderArray.length - 1; i >= 0; --i) {
            try {
                sequence = midiFileReaderArray[i].getSequence(file);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from file");
        }
        return sequence;
    }

    public static int[] getMidiFileTypes() {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        Vector<int[]> vector = new Vector<int[]>();
        int n = 0;
        int n2 = 0;
        int[] nArray = null;
        for (int i = 0; i < midiFileWriterArray.length; ++i) {
            nArray = midiFileWriterArray[i].getMidiFileTypes();
            n += nArray.length;
            vector.addElement(nArray);
        }
        int[] nArray2 = new int[n];
        for (int i = 0; i < vector.size(); ++i) {
            nArray = (int[])vector.elementAt(i);
            for (int j = 0; j < nArray.length; ++j) {
                nArray2[n2++] = nArray[j];
            }
        }
        return nArray2;
    }

    public static boolean isFileTypeSupported(int n) {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        for (int i = 0; i < midiFileWriterArray.length; ++i) {
            if (!midiFileWriterArray[i].isFileTypeSupported(n)) continue;
            return true;
        }
        return false;
    }

    public static int[] getMidiFileTypes(Sequence sequence) {
        int n;
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        int[][] nArrayArray = new int[midiFileWriterArray.length][];
        int[] nArray = null;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < midiFileWriterArray.length; ++n) {
            nArrayArray[n] = midiFileWriterArray[n].getMidiFileTypes(sequence);
            n2 += nArrayArray[n].length;
        }
        nArray = new int[n2];
        for (n = 0; n < midiFileWriterArray.length; ++n) {
            for (int i = 0; i < nArrayArray[n].length; ++i) {
                nArray[n3] = nArrayArray[n][i];
                ++n3;
            }
        }
        return nArray;
    }

    public static boolean isFileTypeSupported(int n, Sequence sequence) {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        for (int i = 0; i < midiFileWriterArray.length; ++i) {
            if (!midiFileWriterArray[i].isFileTypeSupported(n, sequence)) continue;
            return true;
        }
        return false;
    }

    public static int write(Sequence sequence, int n, OutputStream outputStream) throws IOException {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        int n2 = -2;
        for (int i = midiFileWriterArray.length - 1; i >= 0; --i) {
            if (!midiFileWriterArray[i].isFileTypeSupported(n, sequence)) continue;
            n2 = midiFileWriterArray[i].write(sequence, n, outputStream);
            break;
        }
        if (n2 == -2) {
            throw new IllegalArgumentException("MIDI file type is not supported");
        }
        return n2;
    }

    public static int write(Sequence sequence, int n, File file) throws IOException {
        MidiFileWriter[] midiFileWriterArray = MidiSystem.getMidiFileWriters();
        int n2 = -2;
        for (int i = midiFileWriterArray.length - 1; i >= 0; --i) {
            if (!midiFileWriterArray[i].isFileTypeSupported(n, sequence)) continue;
            n2 = midiFileWriterArray[i].write(sequence, n, file);
            break;
        }
        if (n2 == -2) {
            throw new IllegalArgumentException("MIDI file type is not supported");
        }
        return n2;
    }

    private static synchronized boolean isA(Class clazz, Class clazz2) {
        return clazz2.isAssignableFrom(clazz);
    }

    private static Vector getMidiDeviceProviders() {
        Vector vector = null;
        try {
            Class.forName("sun.misc.Service");
            vector = MidiSystem.getJDK13Services("javax.sound.midi.spi.MidiDeviceProvider");
        }
        catch (Exception exception) {
            vector = MidiSystem.getDefaultServices("javax.sound.midi.spi.MidiDeviceProvider");
        }
        return vector;
    }

    private static Vector getSoundbankReaders() {
        Vector vector = null;
        try {
            Class.forName("sun.misc.Service");
            vector = MidiSystem.getJDK13Services("javax.sound.midi.spi.SoundbankReader");
        }
        catch (Exception exception) {
            vector = MidiSystem.getDefaultServices("javax.sound.midi.spi.SoundbankReader");
        }
        return vector;
    }

    private static MidiFileWriter[] getMidiFileWriters() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = MidiSystem.getJDK13Services("javax.sound.midi.spi.MidiFileWriter");
        }
        catch (Exception exception) {
            vector = MidiSystem.getDefaultServices("javax.sound.midi.spi.MidiFileWriter");
        }
        MidiFileWriter[] midiFileWriterArray = new MidiFileWriter[vector.size()];
        for (int i = 0; i < midiFileWriterArray.length; ++i) {
            midiFileWriterArray[i] = (MidiFileWriter)vector.elementAt(i);
        }
        return midiFileWriterArray;
    }

    private static MidiFileReader[] getMidiFileReaders() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = MidiSystem.getJDK13Services("javax.sound.midi.spi.MidiFileReader");
        }
        catch (Exception exception) {
            vector = MidiSystem.getDefaultServices("javax.sound.midi.spi.MidiFileReader");
        }
        MidiFileReader[] midiFileReaderArray = new MidiFileReader[vector.size()];
        for (int i = 0; i < midiFileReaderArray.length; ++i) {
            midiFileReaderArray[i] = (MidiFileReader)vector.elementAt(i);
        }
        return midiFileReaderArray;
    }

    private static MidiDevice.Info[] getGenericDeviceInfo(Class clazz) {
        int n;
        Vector<MidiDevice.Info> vector = new Vector<MidiDevice.Info>();
        Vector vector2 = MidiSystem.getMidiDeviceProviders();
        for (n = 0; n < vector2.size(); ++n) {
            MidiDevice.Info[] infoArray = ((MidiDeviceProvider)vector2.elementAt(n)).getDeviceInfo();
            for (int i = 0; i < infoArray.length; ++i) {
                MidiDevice midiDevice = ((MidiDeviceProvider)vector2.elementAt(n)).getDevice(infoArray[i]);
                if (MidiSystem.isA(clazz, class$javax$sound$midi$Receiver == null ? MidiSystem.class$("javax.sound.midi.Receiver") : class$javax$sound$midi$Receiver)) {
                    if (midiDevice.getMaxReceivers() == 0) continue;
                    vector.addElement(infoArray[i]);
                    continue;
                }
                if (MidiSystem.isA(clazz, class$javax$sound$midi$Transmitter == null ? MidiSystem.class$("javax.sound.midi.Transmitter") : class$javax$sound$midi$Transmitter)) {
                    if (midiDevice.getMaxTransmitters() == 0) continue;
                    vector.addElement(infoArray[i]);
                    continue;
                }
                if (!clazz.isInstance(midiDevice)) continue;
                vector.addElement(infoArray[i]);
            }
        }
        MidiDevice.Info[] infoArray = new MidiDevice.Info[vector.size()];
        for (n = 0; n < infoArray.length; ++n) {
            infoArray[n] = (MidiDevice.Info)vector.elementAt(n);
        }
        return infoArray;
    }

    private static Object getGenericDevice(Class clazz, MidiDevice.Info info) {
        Object var4_2 = null;
        MidiDevice.Info[] infoArray = null;
        Vector vector = new Vector();
        vector = MidiSystem.getMidiDeviceProviders();
        for (int i = 0; i < vector.size(); ++i) {
            MidiDevice midiDevice;
            int n;
            infoArray = ((MidiDeviceProvider)vector.elementAt(i)).getDeviceInfo();
            if (info == null) {
                for (n = 0; n < infoArray.length; ++n) {
                    midiDevice = ((MidiDeviceProvider)vector.elementAt(i)).getDevice(infoArray[n]);
                    if (MidiSystem.isA(clazz, class$javax$sound$midi$Receiver == null ? MidiSystem.class$("javax.sound.midi.Receiver") : class$javax$sound$midi$Receiver)) {
                        if (midiDevice.getMaxReceivers() == 0) continue;
                        return midiDevice;
                    }
                    Class clazz2 = class$javax$sound$midi$Transmitter == null ? MidiSystem.class$("javax.sound.midi.Transmitter") : class$javax$sound$midi$Transmitter;
                    if (!(MidiSystem.isA(clazz, clazz2) ? midiDevice.getMaxTransmitters() != 0 : clazz.isInstance(midiDevice))) continue;
                    return midiDevice;
                }
                continue;
            }
            for (n = 0; n < infoArray.length; ++n) {
                if (!infoArray[n].equals(info)) continue;
                midiDevice = ((MidiDeviceProvider)vector.elementAt(i)).getDevice(infoArray[n]);
                if (clazz == null) {
                    return midiDevice;
                }
                if (!(MidiSystem.isA(clazz, class$javax$sound$midi$Receiver == null ? MidiSystem.class$("javax.sound.midi.Receiver") : class$javax$sound$midi$Receiver) ? midiDevice.getMaxReceivers() != 0 : MidiSystem.isA(clazz, class$javax$sound$midi$Transmitter == null ? MidiSystem.class$("javax.sound.midi.Transmitter") : class$javax$sound$midi$Transmitter) && midiDevice.getMaxTransmitters() != 0)) continue;
                return midiDevice;
            }
        }
        throw new IllegalArgumentException("Requested device not installed: " + info);
    }

    private static Vector getJDK13Services(String string) {
        Vector vector = null;
        try {
            Class<?> clazz = Class.forName(jdk13ServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }

    private static Vector getDefaultServices(String string) {
        Vector vector = null;
        try {
            Class<?> clazz = Class.forName(defaultServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }
}

