/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import sun.print.ServiceDialog;
import sun.print.SunAlternateMedia;

public class ServiceUI {
    public static PrintService printDialog(GraphicsConfiguration graphicsConfiguration, int n, int n2, PrintService[] printServiceArray, PrintService printService, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        int n3 = -1;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (printServiceArray == null || printServiceArray.length == 0) {
            throw new IllegalArgumentException("services must be non-null and non-empty");
        }
        if (printRequestAttributeSet == null) {
            throw new IllegalArgumentException("attributes must be non-null");
        }
        if (printService != null) {
            for (int i = 0; i < printServiceArray.length; ++i) {
                if (!((Object)printServiceArray[i]).equals(printService)) continue;
                n3 = i;
                break;
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("services must contain defaultService");
            }
        } else {
            n3 = 0;
        }
        ServiceDialog serviceDialog = new ServiceDialog(graphicsConfiguration, n, n2, printServiceArray, n3, docFlavor, printRequestAttributeSet);
        serviceDialog.show();
        if (serviceDialog.getStatus() == 1) {
            Class clazz;
            PrintRequestAttributeSet printRequestAttributeSet2 = serviceDialog.getAttributes();
            Class clazz2 = Destination.class;
            Class clazz3 = SunAlternateMedia.class;
            Class clazz4 = clazz = Fidelity.class;
            if (printRequestAttributeSet.containsKey(clazz2) && !printRequestAttributeSet2.containsKey(clazz2)) {
                printRequestAttributeSet.remove(clazz2);
            }
            if (printRequestAttributeSet.containsKey(clazz3) && !printRequestAttributeSet2.containsKey(clazz3)) {
                printRequestAttributeSet.remove(clazz3);
            }
            printRequestAttributeSet.addAll(printRequestAttributeSet2);
            Fidelity fidelity = (Fidelity)printRequestAttributeSet.get(clazz);
            if (fidelity != null && fidelity == Fidelity.FIDELITY_TRUE) {
                ServiceUI.removeUnsupportedAttributes(serviceDialog.getPrintService(), docFlavor, printRequestAttributeSet);
            }
        }
        return serviceDialog.getPrintService();
    }

    private static void removeUnsupportedAttributes(PrintService printService, DocFlavor docFlavor, AttributeSet attributeSet) {
        AttributeSet attributeSet2 = printService.getUnsupportedAttributes(docFlavor, attributeSet);
        if (attributeSet2 != null) {
            Attribute[] attributeArray = attributeSet2.toArray();
            for (int i = 0; i < attributeArray.length; ++i) {
                Class clazz = attributeArray[i].getCategory();
                if (printService.isAttributeCategorySupported(clazz)) {
                    Attribute attribute = (Attribute)printService.getDefaultAttributeValue(clazz);
                    if (attribute != null) {
                        attributeSet.add(attribute);
                        continue;
                    }
                    attributeSet.remove(clazz);
                    continue;
                }
                attributeSet.remove(clazz);
            }
        }
    }
}

