/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.util.Arrays;

public class SinglePixelPackedSampleModel
extends SampleModel {
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] bitSizes;
    private int maxBitSize;
    private int scanlineStride;

    private static native void initIDs();

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int[] nArray) {
        this(n, n2, n3, n2, nArray);
        if (n != 0 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n);
        }
    }

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int n4, int[] nArray) {
        super(n, n2, n3, nArray.length);
        if (n != 0 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n);
        }
        this.dataType = n;
        this.bitMasks = (int[])nArray.clone();
        this.scanlineStride = n4;
        this.bitOffsets = new int[this.numBands];
        this.bitSizes = new int[this.numBands];
        this.maxBitSize = 0;
        for (int i = 0; i < this.numBands; ++i) {
            int n5 = 0;
            int n6 = 0;
            int n7 = nArray[i];
            if (n7 != 0) {
                while ((n7 & 1) == 0) {
                    n7 >>>= 1;
                    ++n5;
                }
                while ((n7 & 1) == 1) {
                    n7 >>>= 1;
                    ++n6;
                }
                if (n7 != 0) {
                    throw new IllegalArgumentException("Mask " + nArray[i] + " must be contiguous");
                }
            }
            this.bitOffsets[i] = n5;
            this.bitSizes[i] = n6;
            if (n6 <= this.maxBitSize) continue;
            this.maxBitSize = n6;
        }
    }

    public int getNumDataElements() {
        return 1;
    }

    private long getBufferSize() {
        long l = this.scanlineStride * (this.height - 1) + this.width;
        return l;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(this.dataType, n, n2, this.bitMasks);
        return singlePixelPackedSampleModel;
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n = (int)this.getBufferSize();
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n);
            }
        }
        return dataBuffer;
    }

    public int[] getSampleSize() {
        int[] nArray = new int[this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            nArray[i] = 0;
            int n = this.bitMasks[i] >>> this.bitOffsets[i];
            while ((n & 1) != 0) {
                int n2 = i;
                nArray[n2] = nArray[n2] + 1;
                n >>>= 1;
            }
        }
        return nArray;
    }

    public int getSampleSize(int n) {
        int n2 = 0;
        int n3 = this.bitMasks[n] >>> this.bitOffsets[n];
        while ((n3 & 1) != 0) {
            ++n2;
            n3 >>>= 1;
        }
        return n2;
    }

    public int getOffset(int n, int n2) {
        int n3 = n2 * this.scanlineStride + n;
        return n3;
    }

    public int[] getBitOffsets() {
        return (int[])this.bitOffsets.clone();
    }

    public int[] getBitMasks() {
        return (int[])this.bitMasks.clone();
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.numBands) {
            throw new RasterFormatException("There are only " + this.numBands + " bands");
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.bitMasks[nArray[i]];
        }
        return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray2);
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = this.getTransferType();
        switch (n3) {
            case 0: {
                byte[] byArray = object == null ? new byte[1] : (byte[])object;
                byArray[0] = (byte)dataBuffer.getElem(n2 * this.scanlineStride + n);
                object = byArray;
                break;
            }
            case 1: {
                short[] sArray = object == null ? new short[1] : (short[])object;
                sArray[0] = (short)dataBuffer.getElem(n2 * this.scanlineStride + n);
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[1] : (int[])object;
                nArray[0] = dataBuffer.getElem(n2 * this.scanlineStride + n);
                object = nArray;
            }
        }
        return object;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray == null ? new int[this.numBands] : nArray;
        int n3 = dataBuffer.getElem(n2 * this.scanlineStride + n);
        for (int i = 0; i < this.numBands; ++i) {
            nArray2[i] = (n3 & this.bitMasks[i]) >>> this.bitOffsets[i];
        }
        return nArray2;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4 * this.numBands];
        int n5 = n2 * this.scanlineStride + n;
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n7 = dataBuffer.getElem(n5 + j);
                for (int k = 0; k < this.numBands; ++k) {
                    nArray2[n6++] = (n7 & this.bitMasks[k]) >>> this.bitOffsets[k];
                }
            }
            n5 += this.scanlineStride;
        }
        return nArray2;
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = dataBuffer.getElem(n2 * this.scanlineStride + n);
        return (n4 & this.bitMasks[n3]) >>> this.bitOffsets[n3];
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4];
        int n6 = n2 * this.scanlineStride + n;
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n8 = dataBuffer.getElem(n6 + j);
                nArray2[n7++] = (n8 & this.bitMasks[n5]) >>> this.bitOffsets[n5];
            }
            n6 += this.scanlineStride;
        }
        return nArray2;
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = this.getTransferType();
        switch (n3) {
            case 0: {
                byte[] byArray = (byte[])object;
                dataBuffer.setElem(n2 * this.scanlineStride + n, byArray[0] & 0xFF);
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                dataBuffer.setElem(n2 * this.scanlineStride + n, sArray[0] & 0xFFFF);
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                dataBuffer.setElem(n2 * this.scanlineStride + n, nArray[0]);
            }
        }
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = n2 * this.scanlineStride + n;
        int n4 = dataBuffer.getElem(n3);
        for (int i = 0; i < this.numBands; ++i) {
            n4 &= ~this.bitMasks[i];
            n4 |= nArray[i] << this.bitOffsets[i] & this.bitMasks[i];
        }
        dataBuffer.setElem(n3, n4);
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = n2 * this.scanlineStride + n;
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n7 = dataBuffer.getElem(n5 + j);
                for (int k = 0; k < this.numBands; ++k) {
                    n7 &= ~this.bitMasks[k];
                    int n8 = nArray[n6++];
                    n7 |= n8 << this.bitOffsets[k] & this.bitMasks[k];
                }
                dataBuffer.setElem(n5 + j, n7);
            }
            n5 += this.scanlineStride;
        }
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = dataBuffer.getElem(n2 * this.scanlineStride + n);
        n5 &= ~this.bitMasks[n3];
        dataBuffer.setElem(n2 * this.scanlineStride + n, n5 |= n4 << this.bitOffsets[n3] & this.bitMasks[n3]);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = n2 * this.scanlineStride + n;
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n8 = dataBuffer.getElem(n6 + j);
                n8 &= ~this.bitMasks[n5];
                int n9 = nArray[n7++];
                dataBuffer.setElem(n6 + j, n8 |= n9 << this.bitOffsets[n5] & this.bitMasks[n5]);
            }
            n6 += this.scanlineStride;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)object;
        return this.width == singlePixelPackedSampleModel.width && this.height == singlePixelPackedSampleModel.height && this.numBands == singlePixelPackedSampleModel.numBands && this.dataType == singlePixelPackedSampleModel.dataType && Arrays.equals(this.bitMasks, singlePixelPackedSampleModel.bitMasks) && Arrays.equals(this.bitOffsets, singlePixelPackedSampleModel.bitOffsets) && Arrays.equals(this.bitSizes, singlePixelPackedSampleModel.bitSizes) && this.maxBitSize == singlePixelPackedSampleModel.maxBitSize && this.scanlineStride == singlePixelPackedSampleModel.scanlineStride;
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        n2 = this.width;
        n2 <<= 8;
        n2 ^= this.height;
        n2 <<= 8;
        n2 ^= this.numBands;
        n2 <<= 8;
        n2 ^= this.dataType;
        n2 <<= 8;
        for (n = 0; n < this.bitMasks.length; ++n) {
            n2 ^= this.bitMasks[n];
            n2 <<= 8;
        }
        for (n = 0; n < this.bitOffsets.length; ++n) {
            n2 ^= this.bitOffsets[n];
            n2 <<= 8;
        }
        for (n = 0; n < this.bitSizes.length; ++n) {
            n2 ^= this.bitSizes[n];
            n2 <<= 8;
        }
        n2 ^= this.maxBitSize;
        n2 <<= 8;
        return n2 ^= this.scanlineStride;
    }

    static {
        SinglePixelPackedSampleModel.initIDs();
    }
}

