/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.SerializationTester;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

public class DragGestureEvent
extends EventObject {
    private static final long serialVersionUID = 9080172649166731306L;
    private transient List events;
    private DragSource dragSource;
    private Component component;
    private Point origin;
    private int action;

    public DragGestureEvent(DragGestureRecognizer dragGestureRecognizer, int n, Point point, List list) {
        super(dragGestureRecognizer);
        this.component = dragGestureRecognizer.getComponent();
        if (this.component == null) {
            throw new IllegalArgumentException("null component");
        }
        this.dragSource = dragGestureRecognizer.getDragSource();
        if (this.dragSource == null) {
            throw new IllegalArgumentException("null DragSource");
        }
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("null or empty list of events");
        }
        if (n != 1 && n != 2 && n != 0x40000000) {
            throw new IllegalArgumentException("bad action");
        }
        if (point == null) {
            throw new IllegalArgumentException("null origin");
        }
        this.events = list;
        this.action = n;
        this.origin = point;
    }

    public DragGestureRecognizer getSourceAsDragGestureRecognizer() {
        return (DragGestureRecognizer)this.getSource();
    }

    public Component getComponent() {
        return this.component;
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public Point getDragOrigin() {
        return this.origin;
    }

    public Iterator iterator() {
        return this.events.iterator();
    }

    public Object[] toArray() {
        return this.events.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.events.toArray(objectArray);
    }

    public int getDragAction() {
        return this.action;
    }

    public InputEvent getTriggerEvent() {
        return this.getSourceAsDragGestureRecognizer().getTriggerEvent();
    }

    public void startDrag(Cursor cursor, Transferable transferable) throws InvalidDnDOperationException {
        this.dragSource.startDrag(this, cursor, transferable, null);
    }

    public void startDrag(Cursor cursor, Transferable transferable, DragSourceListener dragSourceListener) throws InvalidDnDOperationException {
        this.dragSource.startDrag(this, cursor, transferable, dragSourceListener);
    }

    public void startDrag(Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) throws InvalidDnDOperationException {
        this.dragSource.startDrag(this, cursor, image, point, transferable, dragSourceListener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(SerializationTester.test(this.events) ? this.events : null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.dragSource = (DragSource)getField.get("dragSource", null);
        this.component = (Component)getField.get("component", null);
        this.origin = (Point)getField.get("origin", null);
        this.action = getField.get("action", 0);
        try {
            this.events = (List)getField.get("events", null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.events = (List)objectInputStream.readObject();
        }
        if (this.events == null) {
            this.events = Collections.EMPTY_LIST;
        }
    }
}

