/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.util.Locale;
import sun.java2d.HeadlessGraphicsEnvironment;
import sun.java2d.SunGraphicsEnvironment;
import sun.security.action.GetPropertyAction;

public abstract class GraphicsEnvironment {
    private static GraphicsEnvironment localEnv;
    private static Boolean headless;

    protected GraphicsEnvironment() {
    }

    public static synchronized GraphicsEnvironment getLocalGraphicsEnvironment() {
        if (localEnv == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("java.awt.graphicsenv", null));
            try {
                localEnv = (GraphicsEnvironment)Class.forName(string).newInstance();
                if (GraphicsEnvironment.isHeadless()) {
                    localEnv = new HeadlessGraphicsEnvironment(localEnv);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error("Could not find class: " + string);
            }
            catch (InstantiationException instantiationException) {
                throw new Error("Could not instantiate Graphics Environment: " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error("Could not access Graphics Environment: " + string);
            }
        }
        return localEnv;
    }

    public static boolean isHeadless() {
        return GraphicsEnvironment.getHeadlessProperty();
    }

    private static boolean getHeadlessProperty() {
        if (headless == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("java.awt.headless", "false"));
            headless = string.equals("true") ? Boolean.TRUE : Boolean.FALSE;
        }
        return headless;
    }

    static void checkHeadless() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public boolean isHeadlessInstance() {
        return GraphicsEnvironment.getHeadlessProperty();
    }

    public abstract GraphicsDevice[] getScreenDevices() throws HeadlessException;

    public abstract GraphicsDevice getDefaultScreenDevice() throws HeadlessException;

    public abstract Graphics2D createGraphics(BufferedImage var1);

    public abstract Font[] getAllFonts();

    public abstract String[] getAvailableFontFamilyNames();

    public abstract String[] getAvailableFontFamilyNames(Locale var1);

    public Point getCenterPoint() throws HeadlessException {
        Rectangle rectangle = SunGraphicsEnvironment.getUsableBounds(this.getDefaultScreenDevice());
        return new Point(rectangle.width / 2 + rectangle.x, rectangle.height / 2 + rectangle.y);
    }

    public Rectangle getMaximumWindowBounds() throws HeadlessException {
        return SunGraphicsEnvironment.getUsableBounds(this.getDefaultScreenDevice());
    }
}

