/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.CharacterIterator;
import sun.awt.NativeLibLoader;

public abstract class FontMetrics
implements Serializable {
    protected Font font;
    private static final long serialVersionUID = 1681126225205050147L;

    protected FontMetrics(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public int getLeading() {
        return 0;
    }

    public int getAscent() {
        return this.font.getSize();
    }

    public int getDescent() {
        return 0;
    }

    public int getHeight() {
        return this.getLeading() + this.getAscent() + this.getDescent();
    }

    public int getMaxAscent() {
        return this.getAscent();
    }

    public int getMaxDescent() {
        return this.getDescent();
    }

    public int getMaxDecent() {
        return this.getMaxDescent();
    }

    public int getMaxAdvance() {
        return -1;
    }

    public int charWidth(int n) {
        return this.charWidth((char)n);
    }

    public int charWidth(char c) {
        if (c < '\u0100') {
            return this.getWidths()[c];
        }
        char[] cArray = new char[]{c};
        return this.charsWidth(cArray, 0, 1);
    }

    public int stringWidth(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return this.charsWidth(cArray, 0, n);
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        return this.stringWidth(new String(cArray, n, n2));
    }

    public int bytesWidth(byte[] byArray, int n, int n2) {
        return this.stringWidth(new String(byArray, 0, n, n2));
    }

    public int[] getWidths() {
        int[] nArray = new int[256];
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            nArray[c] = this.charWidth(c);
        }
        return nArray;
    }

    public boolean hasUniformLineMetrics() {
        return this.font.hasUniformLineMetrics();
    }

    public LineMetrics getLineMetrics(String string, Graphics graphics) {
        return this.font.getLineMetrics(string, this.myFRC(graphics));
    }

    public LineMetrics getLineMetrics(String string, int n, int n2, Graphics graphics) {
        return this.font.getLineMetrics(string, n, n2, this.myFRC(graphics));
    }

    public LineMetrics getLineMetrics(char[] cArray, int n, int n2, Graphics graphics) {
        return this.font.getLineMetrics(cArray, n, n2, this.myFRC(graphics));
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, Graphics graphics) {
        return this.font.getLineMetrics(characterIterator, n, n2, this.myFRC(graphics));
    }

    public Rectangle2D getStringBounds(String string, Graphics graphics) {
        return this.font.getStringBounds(string, this.myFRC(graphics));
    }

    public Rectangle2D getStringBounds(String string, int n, int n2, Graphics graphics) {
        return this.font.getStringBounds(string, n, n2, this.myFRC(graphics));
    }

    public Rectangle2D getStringBounds(char[] cArray, int n, int n2, Graphics graphics) {
        return this.font.getStringBounds(cArray, n, n2, this.myFRC(graphics));
    }

    public Rectangle2D getStringBounds(CharacterIterator characterIterator, int n, int n2, Graphics graphics) {
        return this.font.getStringBounds(characterIterator, n, n2, this.myFRC(graphics));
    }

    public Rectangle2D getMaxCharBounds(Graphics graphics) {
        return this.font.getMaxCharBounds(this.myFRC(graphics));
    }

    private FontRenderContext myFRC(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            return ((Graphics2D)graphics).getFontRenderContext();
        }
        return new FontRenderContext(null, false, false);
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont() + "ascent=" + this.getAscent() + ", descent=" + this.getDescent() + ", height=" + this.getHeight() + "]";
    }

    private static native void initIDs();

    static {
        NativeLibLoader.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            FontMetrics.initIDs();
        }
    }
}

