/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicMenuUI;

public class WindowsMenuUI
extends BasicMenuUI {
    private boolean isMouseOver = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsMenuUI();
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        JMenu jMenu = (JMenu)jMenuItem;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (WindowsLookAndFeel.isClassicWindows() || !jMenu.isTopLevelMenu() || XPStyle.getXP() != null && (buttonModel.isArmed() || buttonModel.isSelected())) {
            super.paintBackground(graphics, jMenuItem, color);
            return;
        }
        Color color2 = graphics.getColor();
        int n = jMenuItem.getWidth();
        int n2 = jMenuItem.getHeight();
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Color color3 = uIDefaults.getColor("controlLtHighlight");
        Color color4 = uIDefaults.getColor("controlShadow");
        graphics.setColor(jMenuItem.getBackground());
        graphics.fillRect(0, 0, n, n2);
        if (jMenuItem.isOpaque()) {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color4);
                graphics.drawLine(0, 0, n - 1, 0);
                graphics.drawLine(0, 0, 0, n2 - 2);
                graphics.setColor(color3);
                graphics.drawLine(n - 1, 0, n - 1, n2 - 2);
                graphics.drawLine(0, n2 - 2, n - 1, n2 - 2);
            } else if (this.isMouseOver() && buttonModel.isEnabled()) {
                if (XPStyle.getXP() != null) {
                    graphics.setColor(this.selectionBackground);
                    graphics.fillRect(0, 0, n, n2);
                } else {
                    graphics.setColor(color3);
                    graphics.drawLine(0, 0, n - 1, 0);
                    graphics.drawLine(0, 0, 0, n2 - 2);
                    graphics.setColor(color4);
                    graphics.drawLine(n - 1, 0, n - 1, n2 - 2);
                    graphics.drawLine(0, n2 - 2, n - 1, n2 - 2);
                }
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n, n2);
            }
        }
        graphics.setColor(color2);
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        JMenu jMenu = (JMenu)jMenuItem;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (!buttonModel.isEnabled()) {
            WindowsGraphicsUtils.paintText(graphics, jMenuItem, rectangle, string, 0);
        } else {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = jMenuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                n = -1;
            }
            Color color = graphics.getColor();
            if (buttonModel.isSelected() && (WindowsLookAndFeel.isClassicWindows() || !jMenu.isTopLevelMenu()) || XPStyle.getXP() != null && (this.isMouseOver() || buttonModel.isArmed() || buttonModel.isSelected())) {
                graphics.setColor(this.selectionForeground);
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(color);
        }
    }

    private void setMouseOver(boolean bl) {
        this.isMouseOver = bl;
    }

    private boolean isMouseOver() {
        return this.isMouseOver;
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new WindowsMouseInputHandler();
    }

    protected class WindowsMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        protected WindowsMouseInputHandler() {
            super(WindowsMenuUI.this);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            if (!WindowsLookAndFeel.isClassicWindows()) {
                WindowsMenuUI.this.setMouseOver(true);
                WindowsMenuUI.this.menuItem.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            if (!WindowsLookAndFeel.isClassicWindows()) {
                WindowsMenuUI.this.setMouseOver(false);
                WindowsMenuUI.this.menuItem.repaint();
            }
        }
    }
}

