/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class MotifComboBoxUI
extends BasicComboBoxUI
implements Serializable {
    Icon arrowIcon;
    static final int HORIZ_MARGIN = 3;
    private ActionListener editorActionListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.arrowIcon = new MotifComboBoxArrowIcon(UIManager.getColor("controlHighlight"), UIManager.getColor("controlShadow"), UIManager.getColor("control"));
        Runnable runnable = new Runnable(){

            public void run() {
                if (MotifComboBoxUI.this.motifGetEditor() != null) {
                    MotifComboBoxUI.this.motifGetEditor().setBackground(UIManager.getColor("text"));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Insets insets = this.getInsets();
        Dimension dimension = this.getDisplaySize();
        dimension.height += insets.top + insets.bottom;
        int n = this.iconAreaWidth();
        dimension.width += insets.left + insets.right + n;
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return dimension;
    }

    protected ComboPopup createPopup() {
        return new MotifComboPopup(this.comboBox);
    }

    protected KeyListener createKeyListener() {
        return new NoSelectKeyHandler();
    }

    protected void selectNextPossibleValue() {
        int n = this.listBox.getSelectedIndex();
        if (n < this.comboBox.getModel().getSize() - 1) {
            this.listBox.setSelectedIndex(n + 1);
            this.listBox.ensureIndexIsVisible(n + 1);
            this.comboBox.repaint();
        }
    }

    protected void selectPreviousPossibleValue() {
        int n = this.listBox.getSelectedIndex();
        if (n > 0) {
            this.listBox.setSelectedIndex(n - 1);
            this.listBox.ensureIndexIsVisible(n - 1);
            this.comboBox.repaint();
        }
    }

    protected void installComponents() {
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    protected void uninstallComponents() {
        this.removeEditor();
        this.comboBox.removeAll();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle;
        boolean bl = this.comboBox.hasFocus();
        if (this.comboBox.isEnabled()) {
            graphics.setColor(this.comboBox.getBackground());
        } else {
            graphics.setColor(UIManager.getColor("ComboBox.disabledBackground"));
        }
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        if (!this.comboBox.isEditable()) {
            rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValue(graphics, rectangle, bl);
        }
        rectangle = this.rectangleForArrowIcon();
        this.arrowIcon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
        if (!this.comboBox.isEditable()) {
            Border border = this.comboBox.getBorder();
            Insets insets = border != null ? border.getBorderInsets(this.comboBox) : new Insets(0, 0, 0, 0);
            rectangle.x = MotifGraphicsUtils.isLeftToRight(this.comboBox) ? (rectangle.x -= 5) : (rectangle.x += rectangle.width + 3 + 1);
            rectangle.y = insets.top;
            rectangle.width = 1;
            rectangle.height = this.comboBox.getBounds().height - insets.bottom - insets.top;
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++rectangle.x;
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        component.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        Dimension dimension = component.getPreferredSize();
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, dimension.height);
    }

    protected Rectangle rectangleForArrowIcon() {
        Rectangle rectangle = this.comboBox.getBounds();
        Border border = this.comboBox.getBorder();
        Insets insets = border != null ? border.getBorderInsets(this.comboBox) : new Insets(0, 0, 0, 0);
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        rectangle.x = MotifGraphicsUtils.isLeftToRight(this.comboBox) ? rectangle.x + rectangle.width - 3 - this.arrowIcon.getIconWidth() : (rectangle.x += 3);
        rectangle.y += (rectangle.height - this.arrowIcon.getIconHeight()) / 2;
        rectangle.width = this.arrowIcon.getIconWidth();
        rectangle.height = this.arrowIcon.getIconHeight();
        return rectangle;
    }

    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        if (MotifGraphicsUtils.isLeftToRight(this.comboBox)) {
            return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right) - this.iconAreaWidth(), n2 - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + this.iconAreaWidth(), insets.top, n - (insets.left + insets.right) - this.iconAreaWidth(), n2 - (insets.top + insets.bottom));
    }

    public int iconAreaWidth() {
        if (this.comboBox.isEditable()) {
            return this.arrowIcon.getIconWidth() + 6;
        }
        return this.arrowIcon.getIconWidth() + 9 + 2;
    }

    public void configureEditor() {
        super.configureEditor();
        this.editor.setBackground(UIManager.getColor("text"));
        if (this.editorActionListener == null) {
            this.editorActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (MotifComboBoxUI.this.isPopupVisible(MotifComboBoxUI.this.comboBox)) {
                        MotifComboBoxUI.this.comboBox.setSelectedIndex(MotifComboBoxUI.this.listBox.getSelectedIndex());
                    }
                }
            };
            this.comboBox.getEditor().addActionListener(this.editorActionListener);
        }
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.editorActionListener != null) {
            this.comboBox.getEditor().removeActionListener(this.editorActionListener);
            this.editorActionListener = null;
        }
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager();
    }

    private Component motifGetEditor() {
        return this.editor;
    }

    static class MotifComboBoxArrowIcon
    implements Icon,
    Serializable {
        private Color lightShadow;
        private Color darkShadow;
        private Color fill;

        public MotifComboBoxArrowIcon(Color color, Color color2, Color color3) {
            this.lightShadow = color;
            this.darkShadow = color2;
            this.fill = color3;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            graphics.setColor(this.lightShadow);
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2 + 1, n + n3 - 3, n2 + 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 1, n2 + 1);
            int n5 = n + 1;
            int n6 = n2 + 2;
            int n7 = n3 - 6;
            while (n6 + 1 < n2 + n4) {
                graphics.setColor(this.lightShadow);
                graphics.drawLine(n5, n6, n5 + 1, n6);
                graphics.drawLine(n5, n6 + 1, n5 + 1, n6 + 1);
                if (n7 > 0) {
                    graphics.setColor(this.fill);
                    graphics.drawLine(n5 + 2, n6, n5 + 1 + n7, n6);
                    graphics.drawLine(n5 + 2, n6 + 1, n5 + 1 + n7, n6 + 1);
                }
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n5 + n7 + 2, n6, n5 + n7 + 3, n6);
                graphics.drawLine(n5 + n7 + 2, n6 + 1, n5 + n7 + 3, n6 + 1);
                ++n5;
                n7 -= 2;
                n6 += 2;
            }
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n + n3 / 2, n2 + n4 - 1, n + n3 / 2, n2 + n4 - 1);
        }

        public int getIconWidth() {
            return 11;
        }

        public int getIconHeight() {
            return 11;
        }
    }

    public class ComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        public ComboBoxLayoutManager() {
            super(MotifComboBoxUI.this);
        }

        public void layoutContainer(Container container) {
            if (MotifComboBoxUI.this.motifGetEditor() != null) {
                Rectangle rectangle = MotifComboBoxUI.this.rectangleForCurrentValue();
                ++rectangle.x;
                ++rectangle.y;
                --rectangle.width;
                rectangle.height -= 2;
                MotifComboBoxUI.this.motifGetEditor().setBounds(rectangle);
            }
        }
    }

    protected class MotifComboPopup
    extends BasicComboPopup {
        public MotifComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        public MouseMotionListener createListMouseMotionListener() {
            return new MouseMotionAdapter(this){
                private final /* synthetic */ MotifComboPopup this$1;
                {
                    this.this$1 = motifComboPopup;
                }
            };
        }

        public KeyListener createKeyListener() {
            return super.createKeyListener();
        }

        protected class InvocationKeyHandler
        extends BasicComboPopup.InvocationKeyHandler {
            protected InvocationKeyHandler() {
                super(MotifComboPopup.this);
            }
        }
    }

    private class NoSelectKeyHandler
    extends KeyAdapter {
        private NoSelectKeyHandler() {
        }

        private int selectionForKey(char c) {
            String string;
            int n;
            int n2;
            int n3 = -1;
            Object object = MotifComboBoxUI.this.listBox.getSelectedValue();
            ListModel listModel = MotifComboBoxUI.this.listBox.getModel();
            if (object != null) {
                object = object.toString();
                n2 = listModel.getSize();
                for (n = 0; n < n2; ++n) {
                    if (!object.equals(listModel.getElementAt(n).toString())) continue;
                    n3 = n;
                    break;
                }
            }
            String string2 = ("" + c).toLowerCase();
            c = string2.charAt(0);
            n2 = listModel.getSize();
            for (n = ++n3; n < n2; ++n) {
                if (listModel.getElementAt(n) == null || (string = listModel.getElementAt(n).toString().toLowerCase()).length() <= 0 || string.charAt(0) != c) continue;
                return n;
            }
            for (n = 0; n < n3; ++n) {
                if (listModel.getElementAt(n) == null || (string = listModel.getElementAt(n).toString().toLowerCase()).length() <= 0 || string.charAt(0) != c) continue;
                return n;
            }
            return -1;
        }

        private boolean selectWithKeyCharNoAction(char c) {
            int n = this.selectionForKey(c);
            if (n != -1) {
                MotifComboBoxUI.this.comboBox.setPopupVisible(true);
                MotifComboBoxUI.this.listBox.setSelectedIndex(n);
                MotifComboBoxUI.this.listBox.ensureIndexIsVisible(n);
                return true;
            }
            return false;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (MotifComboBoxUI.this.comboBox.isEnabled() && !MotifComboBoxUI.this.isNavigationKey(keyEvent.getKeyCode()) && this.isTypeAheadKey(keyEvent)) {
                if (MotifComboBoxUI.this.comboBox.getKeySelectionManager() != null) {
                    if (MotifComboBoxUI.this.comboBox.selectWithKeyChar(keyEvent.getKeyChar())) {
                        keyEvent.consume();
                    }
                } else if (this.selectWithKeyCharNoAction(keyEvent.getKeyChar())) {
                    keyEvent.consume();
                }
            }
        }

        boolean isTypeAheadKey(KeyEvent keyEvent) {
            return !keyEvent.isAltDown() && !keyEvent.isControlDown() && !keyEvent.isMetaDown();
        }
    }
}

