/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.SynthButtonUI;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

class SynthArrowButton
extends JButton
implements SwingConstants {
    private int direction;

    public SynthArrowButton(int n) {
        this.setFocusable(false);
        this.setDirection(n);
        this.setDefaultCapable(false);
    }

    public String getUIClassID() {
        return "ArrowButtonUI";
    }

    public void updateUI() {
        this.setUI(new SynthArrowButtonUI());
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public int getDirection() {
        return this.direction;
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private static class SynthArrowButtonUI
    extends SynthButtonUI {
        private SynthArrowButtonUI() {
        }

        protected void installDefaults(AbstractButton abstractButton) {
            super.installDefaults(abstractButton);
            this.fetchStyle(abstractButton);
        }

        protected void paint(SynthContext synthContext, Graphics graphics) {
            SynthLookAndFeel.paintForeground(synthContext, graphics, null);
        }

        public Dimension getPreferredSize(JComponent jComponent) {
            SynthContext synthContext = this.getContext(jComponent);
            int n = synthContext.getStyle().getInt(synthContext, "ArrowButton.size", 16);
            synthContext.dispose();
            return new Dimension(n, n);
        }
    }
}

