/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.Metacity;
import com.sun.java.swing.plaf.gtk.SynthContext;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

class MetacityBluecurve
extends Metacity {
    private static final int ArrowWidth = 7;
    private static final int ArrowHeight = 5;
    private static final int ButtonIPad = 3;
    private static final int ThickLineWidth = 3;
    private static final int IconTitleSpacing = 2;
    private static final int LeftTitleTextPad = 6;
    private static final int IconShadowOffset = 1;
    private static final Metacity.FrameGeometry normalFrameGeometry = new NormalFrameGeometry();
    private static final Metacity.FrameGeometry normalMaximizedFrameGeometry = new NormalMaximizedFrameGeometry();
    private HashMap images = new HashMap();

    protected MetacityBluecurve(String string) {
        super(string, normalFrameGeometry);
    }

    private void titlebar_bg_unfocused(Graphics graphics, int n, int n2) {
        this.drawVerticalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 1.0f), MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 0.9f), 0, 0, n, n2);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 0.6f));
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 1.2f));
        graphics.drawLine(0, 0, n, 0);
    }

    private void button_generic_bg_before(Graphics graphics, int n, int n2) {
        this.drawDiagonalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.3f), MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 0.9f), 0, 1, n, n2);
        this.drawDiagonalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 0.9f), MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.3f), 1, 1, n - 2, n2 - 2);
    }

    private void button_generic_bg_before_unfocused(Graphics graphics, int n, int n2) {
        this.titlebar_bg_unfocused(graphics, n, n2);
        this.drawVerticalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.5f), MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 0.95f), 0, 1, n, n2 - 2, 0.1f);
    }

    private void button_generic_bg_after(Graphics graphics, int n, int n2) {
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.DARK), 0.9f));
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
    }

    private void center_button_bg(Graphics graphics, int n, int n2) {
        this.button_generic_bg_before(graphics, n, n2);
        this.button_generic_bg_after(graphics, n, n2);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.2f));
        graphics.drawLine(0, 0, n, 0);
        graphics.setColor(this.getColor(1, GTKColorType.DARK));
        graphics.drawLine(n - 1, 0, n - 1, n2);
    }

    private void center_button_bg_unfocused(Graphics graphics, int n, int n2) {
        this.button_generic_bg_before_unfocused(graphics, n, n2);
    }

    private void right_corner_outline(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.black);
        graphics.drawLine(n - 1, 4, n - 1, n2);
        graphics.drawLine(n - 5, 0, n - 4, 0);
        graphics.drawLine(n - 3, 1, n - 3, 1);
        graphics.drawLine(n - 2, 2, n - 2, 3);
    }

    private void right_corner_button_bg(Graphics graphics, int n, int n2) {
        this.button_generic_bg_before(graphics, n, n2);
        this.button_generic_bg_after(graphics, n, n2);
        this.right_corner_outline(graphics, n, n2);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.2f));
        graphics.drawLine(0, 0, n - 6, 0);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.1f));
        graphics.drawLine(n - 4, 1, n - 5, 1);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 0.9f));
        graphics.drawLine(n - 3, 2, n - 3, 3);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 0.8f));
        graphics.drawLine(n - 2, 4, n - 2, n2 - 2);
    }

    private void right_corner_button_bg_unfocused(Graphics graphics, int n, int n2) {
        this.button_generic_bg_before_unfocused(graphics, n, n2);
        this.right_corner_outline(graphics, n, n2);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 1.2f));
        graphics.drawLine(0, 0, n - 6, 0);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 1.1f));
        graphics.drawLine(n - 4, 1, n - 5, 1);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 0.9f));
        graphics.drawLine(n - 3, 2, n - 3, 3);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 0.8f));
        graphics.drawLine(n - 2, 4, n - 2, n2 - 2);
    }

    private void left_corner_outline(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.black);
        graphics.drawLine(0, 4, 0, n2);
        graphics.drawLine(1, 2, 1, 3);
        graphics.drawLine(2, 1, 2, 1);
        graphics.drawLine(3, 0, 4, 0);
    }

    private void left_corner_button_bg(Graphics graphics, int n, int n2) {
        this.button_generic_bg_before(graphics, n, n2);
        this.button_generic_bg_after(graphics, n, n2);
        this.left_corner_outline(graphics, n, n2);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 1.2f));
        graphics.drawLine(5, 0, n, 0);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.LIGHT), 1.2f));
        graphics.drawLine(1, 4, 1, n2 - 2);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.LIGHT), 1.1f));
        graphics.drawLine(3, 1, 4, 1);
        graphics.drawLine(2, 2, 2, 3);
    }

    private void left_corner_button_bg_unfocused(Graphics graphics, int n, int n2) {
        this.button_generic_bg_before_unfocused(graphics, n, n2);
        this.left_corner_outline(graphics, n, n2);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 1.2f));
        graphics.drawLine(5, 0, n, 0);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.LIGHT), 1.2f));
        graphics.drawLine(1, 4, 1, n2 - 2);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.LIGHT), 1.1f));
        graphics.drawLine(3, 1, 4, 1);
        graphics.drawLine(2, 2, 2, 3);
    }

    private void darken_tint(Graphics graphics, int n, int n2) {
        this.tintRect(graphics, 0, 0, n, n2, MetacityBluecurve.shadeColor(this.getColor(1, GTKColorType.BACKGROUND), 0.75f), 0.5f);
    }

    private void prelight_tint(Graphics graphics, int n, int n2) {
        this.tintRect(graphics, 1, 1, n - 2, n2 - 2, this.getColor(2, GTKColorType.BACKGROUND), 0.4f);
    }

    private void minimize_icon(Graphics graphics, int n, int n2) {
        Image image = this.getImage("minimize", this.getColor(1, GTKColorType.FOREGROUND));
        this.drawImage(graphics, image, this.getColor(1, GTKColorType.FOREGROUND), 0.7f, (n - image.getWidth(null)) / 2, (n2 - image.getHeight(null)) / 2);
    }

    private void menu_icon(Graphics graphics, int n, int n2) {
        Image image = this.getImage("menu", this.getColor(1, GTKColorType.FOREGROUND));
        this.drawImage(graphics, image, this.getColor(1, GTKColorType.FOREGROUND), 0.7f, (n - image.getWidth(null) - 1) / 2, (n2 - image.getHeight(null)) / 2);
    }

    private void maximize_icon(Graphics graphics, int n, int n2) {
        Image image = this.getImage("maximize", this.getColor(1, GTKColorType.FOREGROUND));
        this.drawImage(graphics, image, this.getColor(1, GTKColorType.FOREGROUND), 0.7f, (n - image.getWidth(null)) / 2, (n2 - image.getHeight(null)) / 2);
    }

    private void close_icon(Graphics graphics, int n, int n2) {
        Image image = this.getImage("close", this.getColor(1, GTKColorType.FOREGROUND));
        this.drawImage(graphics, image, this.getColor(1, GTKColorType.FOREGROUND), 0.7f, (n - image.getWidth(null)) / 2, (n2 - image.getHeight(null)) / 2);
    }

    private void close_button(Graphics graphics, int n, int n2) {
        this.right_corner_button_bg(graphics, n, n2);
        this.close_icon(graphics, n, n2);
    }

    private void close_button_prelight(Graphics graphics, int n, int n2) {
        this.right_corner_button_bg(graphics, n, n2);
        this.prelight_tint(graphics, n, n2);
        this.close_icon(graphics, n, n2);
        this.right_corner_outline(graphics, n, n2);
    }

    private void close_button_pressed(Graphics graphics, int n, int n2) {
        this.right_corner_button_bg(graphics, n, n2);
        this.darken_tint(graphics, n, n2);
        this.close_icon(graphics, n, n2);
    }

    private void menu_button(Graphics graphics, int n, int n2) {
        this.left_corner_button_bg(graphics, n, n2);
        graphics.translate(2, 0);
        this.menu_icon(graphics, n, n2);
        graphics.translate(-2, 0);
    }

    private void menu_button_prelight(Graphics graphics, int n, int n2) {
        this.left_corner_button_bg(graphics, n, n2);
        this.prelight_tint(graphics, n, n2);
        graphics.translate(2, 0);
        this.menu_icon(graphics, n, n2);
        graphics.translate(-2, 0);
        this.left_corner_outline(graphics, n, n2);
    }

    private void menu_button_pressed(Graphics graphics, int n, int n2) {
        this.left_corner_button_bg(graphics, n, n2);
        this.darken_tint(graphics, n, n2);
        graphics.translate(2, 0);
        this.menu_icon(graphics, n, n2);
        graphics.translate(-2, 0);
    }

    private void minimize_button(Graphics graphics, int n, int n2, boolean bl) {
        if (bl) {
            this.right_corner_button_bg(graphics, n, n2);
        } else {
            this.center_button_bg(graphics, n, n2);
        }
        this.minimize_icon(graphics, n, n2);
    }

    private void minimize_button_prelight(Graphics graphics, int n, int n2, boolean bl) {
        if (bl) {
            this.right_corner_button_bg(graphics, n, n2);
        } else {
            this.center_button_bg(graphics, n, n2);
        }
        this.prelight_tint(graphics, n, n2);
        this.minimize_icon(graphics, n, n2);
    }

    private void minimize_button_pressed(Graphics graphics, int n, int n2, boolean bl) {
        if (bl) {
            this.right_corner_button_bg(graphics, n, n2);
        } else {
            this.center_button_bg(graphics, n, n2);
        }
        this.darken_tint(graphics, n, n2);
        this.minimize_icon(graphics, n, n2);
    }

    private void maximize_button(Graphics graphics, int n, int n2, boolean bl) {
        if (bl) {
            this.right_corner_button_bg(graphics, n, n2);
        } else {
            this.center_button_bg(graphics, n, n2);
        }
        this.maximize_icon(graphics, n, n2);
    }

    private void maximize_button_prelight(Graphics graphics, int n, int n2, boolean bl) {
        if (bl) {
            this.right_corner_button_bg(graphics, n, n2);
        } else {
            this.center_button_bg(graphics, n, n2);
        }
        this.prelight_tint(graphics, n, n2);
        this.maximize_icon(graphics, n, n2);
    }

    private void maximize_button_pressed(Graphics graphics, int n, int n2, boolean bl) {
        if (bl) {
            this.right_corner_button_bg(graphics, n, n2);
        } else {
            this.center_button_bg(graphics, n, n2);
        }
        this.darken_tint(graphics, n, n2);
        this.maximize_icon(graphics, n, n2);
    }

    void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JInternalFrame jInternalFrame;
        this.context = synthContext;
        JButton jButton = (JButton)synthContext.getComponent();
        String string = jButton.getName();
        int n5 = synthContext.getComponentState();
        JComponent jComponent = (JComponent)jButton.getParent();
        Container container = jComponent.getParent();
        if (container instanceof JInternalFrame) {
            jInternalFrame = (JInternalFrame)container;
        } else if (container instanceof JInternalFrame.JDesktopIcon) {
            jInternalFrame = ((JInternalFrame.JDesktopIcon)container).getInternalFrame();
        } else {
            return;
        }
        boolean bl = jInternalFrame.isSelected();
        this.setFrameGeometry(jComponent, jInternalFrame.isMaximum() ? normalMaximizedFrameGeometry : normalFrameGeometry);
        if (string.equals("InternalFrameTitlePane.menuButton")) {
            if ((n5 & 4) != 0) {
                this.menu_button_pressed(graphics, n3, n4);
            } else if ((n5 & 2) != 0) {
                this.menu_button_prelight(graphics, n3, n4);
            } else {
                this.menu_button(graphics, n3, n4);
            }
        } else if (string.equals("InternalFrameTitlePane.iconifyButton")) {
            boolean bl2;
            boolean bl3 = bl2 = !jInternalFrame.isClosable() && !jInternalFrame.isMaximizable();
            if ((n5 & 4) != 0) {
                this.minimize_button_pressed(graphics, n3, n4, bl2);
            } else if ((n5 & 2) != 0) {
                this.minimize_button_prelight(graphics, n3, n4, bl2);
            } else {
                this.minimize_button(graphics, n3, n4, bl2);
            }
        } else if (string.equals("InternalFrameTitlePane.maximizeButton")) {
            boolean bl4;
            boolean bl5 = bl4 = !jInternalFrame.isClosable();
            if ((n5 & 4) != 0) {
                this.maximize_button_pressed(graphics, n3, n4, bl4);
            } else if ((n5 & 2) != 0) {
                this.maximize_button_prelight(graphics, n3, n4, bl4);
            } else {
                this.maximize_button(graphics, n3, n4, bl4);
            }
        } else if (string.equals("InternalFrameTitlePane.closeButton")) {
            if ((n5 & 4) != 0) {
                this.close_button_pressed(graphics, n3, n4);
            } else if ((n5 & 2) != 0) {
                this.close_button_prelight(graphics, n3, n4);
            } else {
                this.close_button(graphics, n3, n4);
            }
        }
    }

    private void outer_bevel(Graphics graphics, int n, int n2) {
        Metacity.FrameGeometry frameGeometry = this.getFrameGeometry();
        graphics.setColor(Color.black);
        graphics.drawLine(5, 0, n - 6, 0);
        graphics.drawLine(5, n2 - 1, n - 6, n2 - 1);
        graphics.drawLine(0, 5, 0, n2 - 6);
        graphics.drawLine(n - 1, 5, n - 1, n2 - 6);
        graphics.setColor(this.blendColor(this.getColor(1, GTKColorType.LIGHT), Color.white, 0.7f));
        graphics.drawLine(1, 3, 1, n2 - 4);
        graphics.setColor(this.getColor(1, GTKColorType.DARK));
        graphics.drawLine(frameGeometry.left_width - 1, frameGeometry.top_height - 1, frameGeometry.left_width - 1, n2 - frameGeometry.bottom_height);
        graphics.setColor(this.blendColor(this.getColor(1, GTKColorType.BACKGROUND), Color.black, 0.2f));
        graphics.drawLine(3, n2 - 2, n - 4, n2 - 2);
        graphics.setColor(this.getColor(1, GTKColorType.DARK));
        graphics.drawLine(frameGeometry.left_width, n2 - frameGeometry.bottom_height, n - frameGeometry.right_width, n2 - frameGeometry.bottom_height);
        graphics.setColor(this.blendColor(this.getColor(1, GTKColorType.LIGHT), Color.white, 0.7f));
        graphics.drawLine(frameGeometry.left_width, n2 - frameGeometry.bottom_height + 1, n - frameGeometry.right_width, n2 - frameGeometry.bottom_height + 1);
        graphics.setColor(this.getColor(1, GTKColorType.DARK));
        graphics.drawLine(n - frameGeometry.right_width, frameGeometry.top_height - 1, n - frameGeometry.right_width, n2 - frameGeometry.bottom_height);
        graphics.setColor(this.blendColor(this.getColor(1, GTKColorType.LIGHT), Color.white, 0.7f));
        graphics.drawLine(n - frameGeometry.right_width + 1, frameGeometry.top_height - 1, n - frameGeometry.right_width + 1, n2 - frameGeometry.bottom_height + 1);
        graphics.setColor(this.blendColor(this.getColor(1, GTKColorType.BACKGROUND), Color.black, 0.2f));
        graphics.drawLine(n - 2, 3, n - 2, n2 - 4);
    }

    private void corners_unfocused(Graphics graphics, int n, int n2) {
        Color color = MetacityBluecurve.shadeColor(this.getColor(8, GTKColorType.BACKGROUND), 0.8f);
        Image image = this.getImage("bottom_left", color);
        graphics.drawImage(image, 0, n2 - image.getHeight(null), null);
        image = this.getImage("bottom_right", color);
        graphics.drawImage(image, n - image.getWidth(null), n2 - image.getHeight(null), null);
    }

    private void corners_focused(Graphics graphics, int n, int n2) {
        Color color = MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 1.0f);
        Image image = this.getImage("bottom_left", color);
        graphics.drawImage(image, 0, n2 - image.getHeight(null), null);
        image = this.getImage("bottom_right", color);
        graphics.drawImage(image, n - image.getWidth(null), n2 - image.getHeight(null), null);
    }

    private void unfocus_background(Graphics graphics, int n, int n2) {
        this.outer_bevel(graphics, n, n2);
        this.corners_unfocused(graphics, n, n2);
    }

    private void focus_background(Graphics graphics, int n, int n2) {
        this.outer_bevel(graphics, n, n2);
        this.corners_focused(graphics, n, n2);
    }

    private void title_gradient(Graphics graphics, int n, int n2, JInternalFrame jInternalFrame) {
        int n3 = this.calculateTitleWidth(graphics, jInternalFrame);
        this.left_corner_outline(graphics, n, n2);
        this.right_corner_outline(graphics, n, n2);
        this.drawVerticalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 1.4f), MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 1.0f), MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 0.8f), 0, 0, n, n2 - 1);
        Image image = this.getImage("white_stripes_tile");
        this.tileImage(graphics, image, Math.max(6 + n3 - 40, 1), 2, n - (6 + n3 - 40) - 2, n2 - 4, new float[]{0.0f, 0.3f, 0.4f, 0.4f});
        this.drawDiagonalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 2.0f), MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 1.7f), 0, 0, n, 2, 0.2f);
        this.drawVerticalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 2.0f), MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 1.4f), 0, 0, n, 1, 0.4f);
        this.drawDiagonalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 0.8f), MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 0.5f), 0, n2 - 2, n, 2, 0.2f);
        this.drawVerticalGradient(graphics, MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 1.0f), MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 0.7f), 0, n2 - 2, n, 1, 0.9f);
        graphics.setColor(MetacityBluecurve.shadeColor(this.getColor(512, GTKColorType.BACKGROUND), 0.1f));
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
    }

    private void title_text_focused_no_icon(Graphics graphics, int n, int n2, JInternalFrame jInternalFrame) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getAscent() + fontMetrics.getDescent();
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setClip(0, 0, n - 8, n2);
        graphics.setColor(this.blendColor(this.getColor(1, GTKColorType.TEXT_FOREGROUND), this.getColor(512, GTKColorType.BACKGROUND), 0.7f));
        this.paintTitle(graphics, 7, Math.max((n2 - n3) / 2, 0) + 1, jInternalFrame);
        graphics.setColor(this.getColor(512, ColorType.TEXT_FOREGROUND));
        this.paintTitle(graphics, 6, Math.max((n2 - n3) / 2, 0), jInternalFrame);
        graphics.setClip(rectangle);
    }

    private void title_text_no_icon(Graphics graphics, int n, int n2, JInternalFrame jInternalFrame) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getAscent() + fontMetrics.getDescent();
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setClip(0, 0, n - 8, n2);
        graphics.setColor(this.blendColor(this.getColor(8, GTKColorType.TEXT_FOREGROUND), this.getColor(8, GTKColorType.BACKGROUND), 0.0f));
        this.paintTitle(graphics, 6, Math.max((n2 - n3) / 2, 0), jInternalFrame);
        graphics.setClip(rectangle);
    }

    private void title_normal(Graphics graphics, int n, int n2, JInternalFrame jInternalFrame) {
        this.titlebar_bg_unfocused(graphics, n, n2);
        this.title_text_no_icon(graphics, n, n2, jInternalFrame);
        graphics.setColor(this.blendColor(this.getColor(8, GTKColorType.BACKGROUND), this.getColor(8, GTKColorType.FOREGROUND), 0.3f));
        graphics.drawLine(0, 0, 0, n2 - 2);
        graphics.drawLine(n - 1, 0, n - 1, n2 - 2);
    }

    private void title_focused(Graphics graphics, int n, int n2, JInternalFrame jInternalFrame) {
        this.title_gradient(graphics, n, n2, jInternalFrame);
        this.title_text_focused_no_icon(graphics, n, n2, jInternalFrame);
        graphics.setColor(this.blendColor(this.getColor(512, GTKColorType.BACKGROUND), this.getColor(512, GTKColorType.FOREGROUND), 0.4f));
        graphics.drawLine(0, 0, 0, n2);
        graphics.drawLine(n - 1, 0, n - 1, n2);
    }

    private void paintTitle(Graphics graphics, int n, int n2, JInternalFrame jInternalFrame) {
        String string = jInternalFrame.getTitle();
        if (string != null) {
            if (jInternalFrame.getComponentOrientation().isLeftToRight()) {
                string = this.getTitle(string, graphics.getFontMetrics(), this.calculateTitleWidth(graphics, jInternalFrame));
            }
            graphics.drawString(string, n, n2 + graphics.getFontMetrics().getAscent());
        }
    }

    private int calculateTitleWidth(Graphics graphics, JInternalFrame jInternalFrame) {
        Metacity.FrameGeometry frameGeometry = this.getFrameGeometry();
        String string = jInternalFrame.getTitle();
        if (string != null) {
            JComponent jComponent = MetacityBluecurve.findChild(jInternalFrame, "InternalFrame.northPane");
            JComponent jComponent2 = null;
            if (jInternalFrame.isIconifiable()) {
                jComponent2 = MetacityBluecurve.findChild(jComponent, "InternalFrameTitlePane.iconifyButton");
            }
            if (jComponent2 == null && jInternalFrame.isMaximizable()) {
                jComponent2 = MetacityBluecurve.findChild(jComponent, "InternalFrameTitlePane.maximizeButton");
            }
            if (jComponent2 == null && jInternalFrame.isClosable()) {
                jComponent2 = MetacityBluecurve.findChild(jComponent, "InternalFrameTitlePane.closeButton");
            }
            int n = jComponent2 != null ? jComponent2.getX() : jComponent.getWidth() - frameGeometry.right_titlebar_edge;
            return SwingUtilities.computeStringWidth(graphics.getFontMetrics(), string);
        }
        return 0;
    }

    private String getTitle(String string, FontMetrics fontMetrics, int n) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
        String string2 = "...";
        if (n2 > n) {
            int n3;
            int n4 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            for (n3 = 0; n3 < string.length() && (n4 += fontMetrics.charWidth(string.charAt(n3))) <= n; ++n3) {
            }
            string = string.substring(0, n3) + string2;
        }
        return string;
    }

    void paintFrameBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.context = synthContext;
        JComponent jComponent = synthContext.getComponent();
        JInternalFrame jInternalFrame = null;
        if (jComponent instanceof JInternalFrame) {
            jInternalFrame = (JInternalFrame)jComponent;
        } else if (jComponent instanceof JInternalFrame.JDesktopIcon) {
            jInternalFrame = ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame();
        } else {
            return;
        }
        JComponent jComponent2 = MetacityBluecurve.findChild(jInternalFrame, "InternalFrame.northPane");
        jInternalFrame.setOpaque(false);
        MetacityBluecurve.findChild(jComponent2, "InternalFrameTitlePane.closeButton").setOpaque(false);
        boolean bl = jInternalFrame.isSelected();
        Metacity.FrameGeometry frameGeometry = jInternalFrame.isMaximum() ? normalMaximizedFrameGeometry : normalFrameGeometry;
        this.setFrameGeometry(jComponent2, frameGeometry);
        Font font = graphics.getFont();
        graphics.setFont(jComponent2.getFont());
        graphics.translate(n, n2);
        graphics.setColor(jInternalFrame.getBackground());
        graphics.fillRect(0, frameGeometry.top_height, frameGeometry.left_width, n4 - frameGeometry.top_height - frameGeometry.bottom_height);
        graphics.fillRect(n3 - frameGeometry.right_width - 1, frameGeometry.top_height, frameGeometry.right_width, n4 - frameGeometry.top_height - frameGeometry.bottom_height);
        graphics.fillRect(frameGeometry.left_width, n4 - frameGeometry.bottom_height - 1, n3 - frameGeometry.left_width - frameGeometry.right_width, frameGeometry.bottom_height);
        int n5 = 0;
        int n6 = n3;
        JComponent jComponent3 = MetacityBluecurve.findChild(jComponent2, "InternalFrameTitlePane.menuButton");
        if (jComponent3 != null) {
            int n7 = jComponent3.getX() + jComponent3.getWidth() - n;
            n5 += n7;
            n6 -= n7;
        }
        JComponent jComponent4 = null;
        if (jInternalFrame.isIconifiable()) {
            jComponent4 = MetacityBluecurve.findChild(jComponent2, "InternalFrameTitlePane.iconifyButton");
        }
        if (jComponent4 == null && jInternalFrame.isMaximizable()) {
            jComponent4 = MetacityBluecurve.findChild(jComponent2, "InternalFrameTitlePane.maximizeButton");
        }
        if (jComponent4 == null && jInternalFrame.isClosable()) {
            jComponent4 = MetacityBluecurve.findChild(jComponent2, "InternalFrameTitlePane.closeButton");
        }
        if (jComponent4 != null) {
            n6 = Math.min(n3, jComponent4.getX() - n);
        }
        if (!bl) {
            this.unfocus_background(graphics, n3, n4);
            graphics.translate(n5, 1);
            this.title_normal(graphics, n6, jComponent2.getHeight() - 1, jInternalFrame);
            graphics.translate(-n5, -1);
        } else {
            this.focus_background(graphics, n3, n4);
            graphics.translate(n5, 1);
            this.title_focused(graphics, n6, jComponent2.getHeight() - 1, jInternalFrame);
            graphics.translate(-n5, -1);
        }
        graphics.translate(-n, -n2);
        graphics.setFont(font);
    }

    Insets getBorderInsets(SynthContext synthContext, Insets insets) {
        Metacity.FrameGeometry frameGeometry = this.getFrameGeometry();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = frameGeometry.title_border.top;
        insets.bottom = frameGeometry.bottom_height;
        insets.left = frameGeometry.left_width;
        insets.right = frameGeometry.right_width;
        return insets;
    }

    private Image getImage(String string, Color color) {
        Image image = (Image)this.images.get(string + "-" + color.getRGB());
        if (image == null && (image = this.colorizeImage(this.getImage(string), color)) != null) {
            this.images.put(string + "-" + color.getRGB(), image);
        }
        return image;
    }

    private Image getImage(String string) {
        Image image = (Image)this.images.get(string);
        if (image == null) {
            if (this.themeDir != null) {
                final String string2 = this.themeDir + File.separator + string + ".png";
                image = (Image)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new ImageIcon(string2).getImage();
                    }
                });
            } else {
                String string3 = "resources/metacity/" + string + ".png";
                URL uRL = this.getClass().getResource(string3);
                if (uRL != null) {
                    image = new ImageIcon(uRL).getImage();
                }
            }
            if (image != null) {
                this.images.put(string, image);
            }
        }
        return image;
    }

    private void drawImage(Graphics graphics, Image image, Color color, float f, int n, int n2) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            graphics2D.drawImage(image, n, n2, null);
            graphics2D.setComposite(composite);
        }
    }

    private static class NormalMaximizedFrameGeometry
    extends NormalFrameGeometry {
        NormalMaximizedFrameGeometry() {
            this.left_width = 0;
            this.right_width = 0;
            this.bottom_height = 0;
            this.left_titlebar_edge = 0;
            this.right_titlebar_edge = 0;
        }
    }

    private static class NormalFrameGeometry
    extends Metacity.FrameGeometry {
        NormalFrameGeometry() {
            this.left_width = 6;
            this.right_width = 6;
            this.bottom_height = 6;
            this.left_titlebar_edge = 0;
            this.right_titlebar_edge = 0;
            this.title_vertical_pad = 3;
            this.title_border = new Insets(1, 0, 0, 0);
            this.button_border = new Insets(1, 0, 0, 0);
            this.aspect_ratio = 0.9f;
        }
    }
}

