#include <stdio.h>
#include <setjmp.h>
#include <dlfcn.h>
#include <unistd.h>

/* Test program to see if setjmp/longjmp works in a dynamically linked
 * library.
 *
 * Compile with:
 *    gcc -nostartfiles -fpic -shared -o longjmp.so longjmp.c -ldl
 * Usage:
 *    export LD_PRELOAD=longjmp.so
 */

static jmp_buf error_return;

int (*nextwrite)(int, const void *,size_t) = NULL;

void subroutine(int fn, const void *ptr, size_t sz)
{
  int x;

  x = (*nextwrite)(fn,ptr,sz);
  longjmp(error_return, x);
}

ssize_t __write(int fn, const void *ptr, size_t sz)
{
  int x;

  if (nextwrite == NULL) {
    nextwrite = dlsym(RTLD_NEXT,"__write");
  }

  if (x = setjmp(error_return)) {
    (*nextwrite)(1,"setjmp\n",6);
    return x;
  }

  subroutine(fn, ptr, sz);
}
