/*
 * instlog.c: Log what an installer does.
 *
 * Copyright (c) 1996 Matthias Urlichs <smurf@noris.de>
 * 
 * This is free software. You can redistribute it and/or modify it under
 * the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * Usage example:
 * % gcc -fpic -shared -o instlog.so instlog.c
 * % LOGFILE=/proc/self/fd/2 LD_PRELOAD=$(pwd)/instlog.so   touch foo
 * RUN
 * NEW foo
 * %
 *
 * You probably need a reasonably new ld-linux.so and gcc for this.
 * I used gcc-2.7.2 and ld-linux-1.8.0.
 */

#define open ignore_open /* no prototype for open (varargs...) */
#define open64 ignore_open64 /* no prototype for open (varargs...) */
#define __open ignore___open
#define __open64 ignore___open64
#define __libc_open ignore___open

#include <sys/file.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <assert.h>
#include <syscall-list.h>
#include <asm/unistd.h>
#include <features.h>
#include <unistd.h>

#undef open
#undef open64
#undef __open
#undef __open64
#undef __libc_open

#define _NAME(foo) #foo
#define NAME(foo) _NAME(foo)

#if 1
#define N_open "open"
#else
#if __GLIBC_MINOR__ >= 1
#define N_open NAME(__libc_open)
#else
#define N_open NAME(__open)
#endif
#endif

#if 0
#define dwrite write
#else
#define dwrite(a,b,c)
#endif

FILE *logf = NULL;
static int did_logf = 0;
static int in_dlopen = 0;
static int in_open = 0;
static int has_dir = 0;

static void
init_logger (void)
{
	const char *fname;
	int logi, logix;

dwrite(1,"A",1);
	in_dlopen = 1;
	fname = getenv("LOGFILE");
	if(fname == NULL)
		fname = "/var/log/installed";
	if(!did_logf) {
		did_logf=1;
		in_open++;
		logi = open(fname,O_WRONLY|O_APPEND|O_CREAT);
		in_open--;
		if (logi > 0) 
			logix = dup2(logi,69);
		else
			logix = -1;
		if(logix == 69) {
			close(logi);
			logf = fdopen(logix,"a");
		} else {
			if(logi >= 0)
				close(logi);
			logf = NULL;
		}
		
		if(logf != NULL) {
			setlinebuf(logf);
			fprintf(logf,"RUN");
#if 0
			while(*argv) 
				fprintf(logf," %s",*argv++); /* TODO: correct quoting */
#endif
			fprintf(logf, "\n");
		}
	}
	in_dlopen = 0;
}

/*
 * This won't work...
 *
text_set_element (__libc_subinit, init_logger);
 */

static void getdir(void)
{
	static char* (*libc_getcwd)(char *, int) = NULL;
	char path[200];

dwrite(1,"B",1);
	if(has_dir || !logf)
		return;
	has_dir = 2;
	if(!libc_getcwd)
		libc_getcwd = (typeof(libc_getcwd))dlsym (RTLD_NEXT, "getcwd");
	if((*libc_getcwd)(path, sizeof path) == NULL) {
		fprintf(logf,"CWD ?\n");
	} else {
		fprintf(logf,"CWD %s\n",path);
	}
	has_dir = 1;
}

#if __GNU_LIBRARY__ - 0 < 6
#define STAT _xstat
#else
#define STAT __xstat
#endif

int STAT(int v, const char *a, struct stat *b){
	static int (*libc_stat)(int, const char *, struct stat *) = NULL;
	static int in_stat = 0;

dwrite(1,"C",1);
	if(!libc_stat)
		libc_stat = (typeof(libc_stat))dlsym (RTLD_NEXT, NAME(STAT));
	if(in_stat)
		return (*libc_stat)(v,a,b);
	in_stat = 1;
	if(logf == NULL)
		init_logger();
dwrite(1,"2",1);
dwrite(1,"1",1);
	if(in_dlopen || (has_dir > 1)) {
if(in_dlopen) dwrite(1,"y",1);
if(has_dir) dwrite(1,"z",1);
		in_stat = 0;
		return (*libc_stat)(v,a,b);
	}
dwrite(1,"3",1);
	if(*a != '/')
		getdir();
dwrite(1,"4",1);
	if(logf != NULL)
		fprintf(logf,"STN %s\n",a);
	in_stat = 0;
dwrite(1,"5",1);

	return (*libc_stat)(v,a,b);
}
#undef STAT
#if (__GNU_LIBRARY__ - 0 == 6) && defined(__ELF__)
#pragma weak _xstat = __xstat
#endif

#if __GNU_LIBRARY__ - 0 < 6
#define STAT _lxstat
#else
#define STAT __lxstat
#endif

int STAT(int v, const char *a, struct stat *b){
	static int (*libc_stat)(int, const char *, struct stat *) = NULL;
	static int in_stat = 0;

dwrite(1,"D",1);
	if(!libc_stat)
		libc_stat = (typeof(libc_stat))dlsym (RTLD_NEXT, NAME(STAT));
	if(in_stat || in_dlopen || (has_dir > 1))
		return (*libc_stat)(v,a,b);
	in_stat = 1;
	if(logf == NULL)
		init_logger();
	if(*a != '/')
		getdir();
	if(logf != NULL)
		fprintf(logf,"STL %s\n",a);
	in_stat = 0;

	return (*libc_stat)(v,a,b);
}
/* #undef STAT ** wird noch gebraucht */
#if (__GNU_LIBRARY__ - 0 == 6) && defined(__ELF__)
#pragma weak _lxstat = __lxstat
#endif


int __open(const char *a, int b, int c) {
	static int (*libc_open)(const char *,int,int) = NULL;

dwrite(1,"E",1);
	if(!libc_open)
		libc_open = (typeof(libc_open))dlsym (RTLD_NEXT, "" N_open);
dwrite(1,"a",1);
	if(in_open || in_dlopen) 
		return (*libc_open)(a,b,c);
	in_open = 1;
dwrite(1,"b",1);
	if(logf == NULL) 
		init_logger();

dwrite(1,"c",1);
	if(logf && (b & O_CREAT)) {
		static int (*libc_stat)(int, const char *, struct stat *) = NULL;
		struct stat st;

dwrite(1,"d",1);
		if(*a != '/')
			getdir();

dwrite(1,"e",1);
		if(!libc_stat)
			libc_stat = (typeof(libc_stat))dlsym (RTLD_NEXT, NAME(STAT));
dwrite(1,"f",1);
		if(((*libc_stat)(_STAT_VER,a,&st) == -1)) 
			fprintf(logf,"NEW %s\n",a);
		else
			fprintf(logf,"NW? %s\n",a);
	}
	in_open = 0;
	return (*libc_open)(a,b,c);
}
int open(const char *a, int b, int c) { return __open(a,b,c); }
int open64(const char *a, int b, int c) { return __open(a,b,c); }
int __open64(const char *a, int b, int c) { return __open(a,b,c); }
int __libc_open(const char *a, int b, int c) { return __open(a,b,c); }

int __creat(const char *a, __mode_t b) {
	static int (*libc_creat)(const char *,__mode_t) = NULL;

dwrite(1,"E",1);
	if(!libc_creat)
		libc_creat = (typeof(libc_creat))dlsym (RTLD_NEXT, "creat");
dwrite(1,"b",1);
	if(logf == NULL) 
		init_logger();
dwrite(1,"c",1);
    {
		static int (*libc_stat)(int, const char *, struct stat *) = NULL;
		struct stat st;

dwrite(1,"d",1);
		if(*a != '/')
			getdir();

dwrite(1,"e",1);
		if(!libc_stat)
			libc_stat = (typeof(libc_stat))dlsym (RTLD_NEXT, NAME(STAT));
dwrite(1,"f",1);
		if(((*libc_stat)(_STAT_VER,a,&st) == -1)) 
			fprintf(logf,"NEW %s\n",a);
		else
			fprintf(logf,"NW? %s\n",a);
	}
	return (*libc_creat)(a,b);
}
int creat(const char *a, __mode_t b) { return __creat(a,b); }
int creat64(const char *a, __mode_t b) { return __creat(a,b); }


int __rename(const char *a,const char *b)
{
	static int (*libc_rename)(const char *,const char *) = NULL;

dwrite(1,"F",1);
	if(logf == NULL)
		init_logger();
	if(!libc_rename)
		libc_rename = (typeof(libc_rename))dlsym (RTLD_NEXT, "rename");
	if(logf)
		fprintf(logf,"REN %s %s\n",a,b);
	return (*libc_rename)(a,b);
}
int rename(const char *a,const char *b){return __rename(a,b);}


int __link(const char *a,const char *b)
{
	static int (*libc_link)(const char *,const char *) = NULL;
	
dwrite(1,"G",1);
	if(logf == NULL)
		init_logger();
	if(!libc_link)
		libc_link = (typeof(libc_link))dlsym (RTLD_NEXT, "link");
	if(*a != '/' || *b != '/')
		getdir();
	if(logf)
		fprintf(logf,"LNK %s %s\n",a,b);
	return (*libc_link)(a,b);
}
int link(const char *a,const char *b){return __link(a,b);}


int __chdir(const char *a)
{
	static int (*libc_chdir)(const char *) = NULL;
	
dwrite(1,"H",1);
	if(!libc_chdir)
		libc_chdir = (typeof(libc_chdir))dlsym (RTLD_NEXT, "chdir");
	has_dir = 0;
	return (*libc_chdir)(a);
}
int chdir(const char *a){ return __chdir(a);}


int __fchdir(int a)
{
	static int (*libc_fchdir)(int) = NULL;
	
dwrite(1,"I",1);
	if(!libc_fchdir)
		libc_fchdir = (typeof(libc_fchdir))dlsym (RTLD_NEXT, "fchdir");
	has_dir = 0;
	return (*libc_fchdir)(a);
}
int fchdir(int a){return __fchdir(a);}


int __symlink(const char *a,const char *b)
{
	static int (*libc_symlink)(const char *,const char *) = NULL;

dwrite(1,"J",1);
	if(logf == NULL)
		init_logger();
	if(!libc_symlink)
		libc_symlink = (typeof(libc_symlink))dlsym (RTLD_NEXT, "symlink");
	if(*a != '/' || *b != '/')
		getdir();
	if(logf)
		fprintf(logf,"SLN %s %s\n",a,b);
	return (*libc_symlink)(a,b);
}
int symlink(const char *a,const char *b){ return __symlink(a,b);}


int __unlink(const char *a)
{
	static int (*libc_unlink)(const char *) = NULL;

dwrite(1,"K",1);
	if(logf == NULL)
		init_logger();
	if(!libc_unlink)
		libc_unlink = (typeof(libc_unlink))dlsym (RTLD_NEXT, "unlink");
	if(*a != '/')
		getdir();
	if(logf)
		fprintf(logf,"DEL %s\n",a);
	return (*libc_unlink)(a);
}
int unlink(const char *a){return __unlink(a);}


int __execve(const char *a, char *const b[], char *const c[])
{
	static int (*libc_execve) (const char *path, char *const argv[], char *const envp[]);

dwrite(1,"L",1);
	if(logf == NULL)
		init_logger();
	if(!libc_execve)
		libc_execve = (typeof(libc_execve))dlsym (RTLD_NEXT, "execve");
	if(*a != '/')
		getdir();
	if(logf) {
		fprintf(logf,"RUN %s\n",a);
		fflush(logf);
		fclose(logf);
		logf = NULL;
		did_logf = 0;
	}
	return (*libc_execve)(a,b,c);
}
int execve(const char *a, char *const b[], char *const c[]){return __execve(a,b,c);}


int __mkdir(const char *a, mode_t b)
{
	static int (*libc_mkdir)(const char *,mode_t) = NULL;

dwrite(1,"M",1);
	if(logf == NULL)
		init_logger();
	if(!libc_mkdir)
		libc_mkdir = (typeof(libc_mkdir))dlsym (RTLD_NEXT, "mkdir");
	if(*a != '/')
		getdir();
	if(logf)
		fprintf(logf,"DIR %s 0%o\n",a,b);
	return (*libc_mkdir)(a,b);
}
int mkdir(const char *a, mode_t b){return __mkdir(a,b);}


int __access(const char *a, int b)
{
	static int (*libc_access)(const char *,int) = NULL;

dwrite(1,"N",1);
	if(logf == NULL)
		init_logger();
	if(!libc_access)
		libc_access = (typeof(libc_access))dlsym (RTLD_NEXT, "access");
	if(*a != '/')
		getdir();
	if(logf)
		fprintf(logf,"ACC %s 0%o\n",a,b);
	return (*libc_access)(a,b);
}
int access(const char *a, int b){return __access(a,b);}

/* End of file */
