Summary: GNU libc
Name: glibc
Version: 2.1.1
%define DATE 990416
Release: 7
Copyright: LGPL
Group: System Environment/Libraries
Source0: glibc-%{DATE}.tar.gz
Source1: http://www.ozemail.com.au/~geoffk/glibc-crypt/glibc-crypt-2.1.tar.gz
Source2: glibc-compat-2.1.0.tar.gz
Source3: glibc-2.1-nsswitch.conf
Patch0: glibc-2.1-rhpaths.patch
Patch1: glibc-2.1-noversion.patch
Patch2: glibc-2.1-cppfix.patch
Patch3: glibc-2.1.1-nscd.patch
Patch4: glibc-2.1.1-libio-vfork.patch
Patch5: glibc-2.1.1-libc4.patch
Patch6: glibc-2.1.1-noctty.patch
Patch7: glibc-2.1.1-fstatvfs.patch
Patch10: glibc-2.1.1-nscdhup.patch
Patch11: glibc-2.1.1-LD_PRELOAD.patch
Buildroot: /var/tmp/glibc-%{PACKAGE_VERSION}-root
Obsoletes: zoneinfo, libc-static, libc-devel, libc-profile, libc-headers,
Obsoletes:  linuxthreads, gencat, locale
Autoreq: false
%ifarch alpha
Provides: ld.so.2
%else
%endif
%ifarch sparc
Obsoletes: libc
%endif

%description
Contains the standard libraries that are used by multiple programs on
the system. In order to save disk space and memory, as well as to
ease upgrades, common system code is kept in one place and shared between
programs. This package contains the most important sets of shared libraries,
the standard C library and the standard math library. Without these, a
Linux system will not function. It also contains national language (locale)
support and timezone databases.

%package devel
Summary: Additional libraries required to compile
Group: Development/Libraries
Conflicts: texinfo < 3.11
Prereq: /sbin/install-info
Obsoletes: libc-debug, libc-headers, libc-devel, linuxthreads-devel
Obsoletes: glibc-debug
Prereq: kernel-headers
Requires: kernel-headers >= 2.2.1
Autoreq: true

%description devel
To develop programs which use the standard C libraries (which nearly all
programs do), the system needs to have these standard header files and object
files available for creating the executables.

%package profile
Summary: glibc with profiling support
Group: Development/Libraries
Obsoletes: libc-profile
Autoreq: true

%description profile
When programs are being profiled used gprof, they must use these libraries
instrad of the standard C libraries for gprof to be able to profile
them correctly.

%package -n nscd
Summary: Name Service Caching Daemon
Group: System Environment/Daemons
Conflicts: kernel < 2.2.0
Prereq: /sbin/chkconfig
Autoreq: true

%description -n nscd
nscd caches name service lookups; it can dramatically improve performance
with NIS+, and may help with DNS as well.

You cannot use nscd with 2.0 kernels, due to bugs in the kernel-side thread
support. nscd happens to hit these bugs particularly hard.

%prep
%setup -n glibc -q -a 1 -a 2
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p0
%patch5 -p1
%patch6 -p1
%patch7 -p0
%patch10 -p0
%patch11 -p0
 
%ifarch armv4l
rm -rf glibc-compat
%endif

find . -type f -size 0 -exec rm -f {} \;

%build
rm -rf build-$RPM_ARCH-linux
mkdir build-$RPM_ARCH-linux ; cd build-$RPM_ARCH-linux
%ifarch i586 i686
BuildFlags="-mpentium -D__USE_STRING_INLINES -fstrict-aliasing"
%endif
CC=egcs CFLAGS="$BuildFlags -g -O3" ../configure --prefix=/usr \
	--enable-add-ons=yes --without-cvs  \
	%{_target_cpu}-redhat-linux
make -r CFLAGS="$BuildFlags -g -O3"

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
make install_root=$RPM_BUILD_ROOT install -C build-$RPM_ARCH-linux
cd build-$RPM_ARCH-linux && \
    make install_root=$RPM_BUILD_ROOT install-locales -C ../localedata objdir=`pwd` && \
    cd ..

# Remove the files we don't want to distribute
rm -f $RPM_BUILD_ROOT/usr/lib/libNoVersion*

# the man pages for the linuxthreads require special attention
make -C linuxthreads/man
mkdir -p $RPM_BUILD_ROOT/usr/man/man3
install -m 0644 linuxthreads/man/*.3thr $RPM_BUILD_ROOT/usr/man/man3

gzip -9nvf $RPM_BUILD_ROOT/usr/info/libc*

ln -sf libbsd-compat.a $RPM_BUILD_ROOT/usr/lib/libbsd.a

install -m 644 $RPM_SOURCE_DIR/glibc-2.1-nsswitch.conf \
	$RPM_BUILD_ROOT/etc/nsswitch.conf

# This is for ncsd - in glibc 2.1
install -m 644 nscd/nscd.conf $RPM_BUILD_ROOT/etc
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
install -m 755 nscd/nscd.init $RPM_BUILD_ROOT/etc/rc.d/init.d/nscd

# The database support
mkdir -p $RPM_BUILD_ROOT/var/db
install -m 644 nss/db-Makefile $RPM_BUILD_ROOT/var/db/Makefile

# Strip binaries
strip $RPM_BUILD_ROOT/sbin/* || :
strip $RPM_BUILD_ROOT/usr/bin/* || :
strip $RPM_BUILD_ROOT/usr/sbin/* || :

# BUILD THE FILE LIST
find $RPM_BUILD_ROOT -type f -or -type l | 
	sed -e 's|.*/etc|%config &|' > rpm.filelist.in
for n in /usr/share /usr/include; do 
    find ${RPM_BUILD_ROOT}${n} -type d | \
	grep -v '^/usr/share$' | \
	sed "s/^/%dir /" >> rpm.filelist.in
done

# primary filelist
sed "s|$RPM_BUILD_ROOT||" < rpm.filelist.in | 
	grep -v '/etc/localtime'  | \
	sort > rpm.filelist

grep '/usr/lib/lib.*_p\.a' < rpm.filelist > profile.filelist
egrep "(/usr/include)|(/usr/info)" < rpm.filelist | 
	grep -v /usr/info/dir > devel.filelist

mv rpm.filelist rpm.filelist.full
grep -v '/usr/lib/lib.*_p.a' rpm.filelist.full | 
	egrep -v "(/usr/include)|(/usr/info)" > rpm.filelist

grep '/usr/lib/lib.*\.a' < rpm.filelist >> devel.filelist
grep '/usr/lib/.*\.o' < rpm.filelist >> devel.filelist
grep '/usr/lib/lib.*\.so' < rpm.filelist >> devel.filelist
grep '/usr/man/man' < rpm.filelist >> devel.filelist

mv rpm.filelist rpm.filelist.full
grep -v '/usr/lib/lib.*\.a' < rpm.filelist.full |
	grep -v '/usr/lib/.*\.o' |
	grep -v '/usr/lib/lib.*\.so'|
	grep -v '/usr/man/man' | 
	grep -v 'nscd' > rpm.filelist

# /etc/localtime - we're proud of outr timezone
rm -f $RPM_BUILD_ROOT/etc/localtime
ln -sf ../usr/share/zoneinfo/US/Eastern $RPM_BUILD_ROOT/etc/localtime

# the last bit: more documentation
rm -rf documentation
mkdir documentation
cp linuxthreads/ChangeLog  documentation/ChangeLog.threads
cp linuxthreads/Changes documentation/Changes.threads
cp linuxthreads/README documentation/README.threads
cp linuxthreads/FAQ.html documentation/FAQ-threads.html
cp -r linuxthreads/Examples documentation/examples.threads
cp crypt/README documentation/README.crypt
cp db2/README documentation/README.db2
cp db2/mutex/README documentation/README.db2.mutex
cp timezone/README documentation/README.timezone
cp ChangeLog* documentation
gzip -9 documentation/ChangeLog*

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post devel
/sbin/install-info /usr/info/libc.info.gz /usr/info/dir

%preun devel
if [ "$1" = 0 ]; then
    /sbin/install-info --delete /usr/info/libc.info.gz /usr/info/dir
fi

%post -n nscd
/sbin/chkconfig --add nscd

%preun -n nscd
if [ $1 = 0 ] ; then
    /sbin/chkconfig --del nscd
fi

%clean
rm -rf "$RPM_BUILD_ROOT"
rm -f *.filelist*

%files -f rpm.filelist
%defattr(-,root,root)
%config(noreplace) /etc/localtime
%doc README NEWS INSTALL FAQ BUGS NOTES PROJECTS
%doc documentation/* README.template README.libm
%doc login/README.utmpd hesiod/README.hesiod
%dir /var/db

%files -f devel.filelist devel
%defattr(-,root,root)

%files -f profile.filelist profile
%defattr(-,root,root)

%files -n nscd
%defattr(-,root,root)
%config /etc/nscd.conf
/etc/rc.d/init.d/nscd
/usr/sbin/nscd

%changelog
* Tue Oct 12 1999 Brent Baccala <baccala@freesoft.org>
- make some functions global needed by LD_PRELOAD libraries

* Wed Apr 14 1999 Cristian Gafton <gafton@redhat.com>
- new CVS update - some patches dropped out
- updated obsoletes tag lines
- patch for the ukraine support

* Fri Apr 09 1999 Cristian Gafton <gafton@redhat.com>
- add patch for libstdc++ 2.7.2 (enable __dup, __pipe and __waitpid)
- linuxthread patch from HJLu
- add patch to make nscd respond to SIGHUP by dumping the cache

* Wed Apr 07 1999 Cristian Gafton <gafton@redhat.com>
- updated from cvs tree
- add patch for fstatvfs from HJLu

* Thu Apr 01 1999 Cristian Gafton <gafton@redhat.com>
- opentty fix
- don't call lddlibc4 on sparcs

* Thu Mar 25 1999 Cristian Gafton <gafton@redhat.com>
- version 2.1.1
- make nscd run by default at init
- nscd subpackage
- let the subpackages autoreq their own thing

* Fri Mar 12 1999 Cristian Gafton <gafton@redhat.com>
- version 2.1
- strip binaries installed by default

* Thu Feb 18 1999 Cristian Gafton <gafton@redhat.com>
- updated snapshot
- glibc-crypt might have export problems (who knows?), so we are nosource
  iit for now

* Wed Feb 03 1999 Cristian Gafton <gafton@redhat.com>
- version 2.0.112
- merge glibc-debug into glibc-devel
- new compat add-on

* Wed Jan 13 1999 Cristian Gafton <gafton@redhat.com>
- new glibc-crypt add-on
- version 2.0.109
- handle /etc/localtime separately
- don't include /usr/share in the file list
- don not build glibc-compat on the arm

* Wed Dec 02 1998 Cristian Gafton <gafton@redhat.com>
- build ver 2.0.105 on all four arches
- enabled /usr/include/scsi as part of the glibc package

* Fri Oct 02 1998 Cristian Gafton <gafton@redhat.com>
- first build for 2.0.96
